/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.converters;

public class GenericDataTable {
    protected int height;
    protected int width;
    protected String[] header;
    protected String[][] content;
    protected boolean withHeader = false;

    public GenericDataTable(int height, int width) {
        this(height, width, false);
    }

    public GenericDataTable(int height, int width, boolean withHeader) {
        this.width = width;
        this.height = height;
        this.withHeader = withHeader;
        if (this.withHeader) {
            this.header = new String[width];
        }
        this.content = new String[height][width];
    }

    public String[][] getContent() {
        return this.content;
    }

    public String getContent(int row, int column) {
        return this.content[row][column];
    }

    public String[] getRow(int row) {
        return this.content[row];
    }

    public void setRow(int row, String[] rowContent) {
        int i = 0;
        while (i < this.width) {
            this.content[row][i] = rowContent[i];
            ++i;
        }
    }

    public String[] getHeader() {
        return this.header;
    }

    public void setHeader(String[] header) {
        this.header = header;
    }

    public void setContent(int row, int column, String value) {
        if (row >= this.height) {
            throw new ArrayIndexOutOfBoundsException(" y-value too high: " + row + ", maxHeight was: " + (this.height - 1));
        }
        if (column >= this.width) {
            throw new ArrayIndexOutOfBoundsException(" x-value too high: " + column + ", max-Width was: " + (this.width - 1));
        }
        this.content[row][column] = value;
    }

    protected void setContent(int height, int width, String[][] content) {
        this.height = height;
        this.width = width;
        this.content = content;
    }

    public boolean isWithHeader() {
        return this.withHeader;
    }

    public void setWithHeader(boolean noHeader) {
        this.withHeader = noHeader;
    }

    public int size() {
        return this.height;
    }
}

