/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.indel;

import dr.oldevomodel.indel.IntMathVec;

public class NativeTreeLikelihood {
    private static boolean isNativeAvailable = false;
    private int[][] iSequences;
    private int iNN;
    private int iMUD;
    private long iStaticDataHandle;

    public boolean isAvailable() {
        return isNativeAvailable;
    }

    private native long nativeInit(int[] var1, double[] var2, double[] var3, double[] var4, double[] var5, double[] var6, double[] var7);

    private native double nativeTreeRecursion(int[] var1, int[] var2, int var3, int var4, long var5);

    private native void nativeDestruct(long var1);

    public void init(int n, int n2, int[] nArray, double[] dArray, double[][][] dArray2, int[][] nArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        if (!isNativeAvailable) {
            return;
        }
        this.iNN = n;
        this.iMUD = n2;
        this.iSequences = nArray2;
        int n3 = dArray2.length;
        double[] dArray7 = new double[this.iNN * this.iNN * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < this.iNN; ++j) {
                for (int k = 0; k < this.iNN; ++k) {
                    dArray7[k + this.iNN * (j + this.iNN * i)] = dArray2[i][j][k];
                }
            }
        }
        this.iStaticDataHandle = this.nativeInit(nArray, dArray, dArray7, dArray4, dArray3, dArray5, dArray6);
    }

    protected void finalize() throws Throwable {
        if (this.iStaticDataHandle != 0L) {
            this.nativeDestruct(this.iStaticDataHandle);
        }
        super.finalize();
    }

    public double treeRecursion(IntMathVec intMathVec, IntMathVec intMathVec2) {
        int[] nArray = new int[intMathVec.iV.length];
        for (int i = 0; i < intMathVec.iV.length; ++i) {
            if (intMathVec.iV[i] == 0) continue;
            nArray[i] = this.iSequences[i][intMathVec2.iV[i]];
        }
        return this.nativeTreeRecursion(intMathVec.iV, nArray, this.iNN, this.iMUD, this.iStaticDataHandle);
    }

    static {
        try {
            System.loadLibrary("NativeTreeLikelihood");
            System.err.println("Fast TKF91 homology integrator code found");
            isNativeAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Using Java TKF91 homology integrator code");
        }
    }
}

