/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import java.util.List;

public class ProductParameter
extends Parameter.Abstract
implements VariableListener {
    private final List<Parameter> paramList;
    private Bounds bounds = null;

    public ProductParameter(List<Parameter> list) {
        this.paramList = list;
        for (Parameter parameter : this.paramList) {
            parameter.addVariableListener(this);
        }
    }

    @Override
    public int getDimension() {
        return this.paramList.get(0).getDimension();
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    protected void storeValues() {
        for (Parameter parameter : this.paramList) {
            parameter.storeParameterValues();
        }
    }

    @Override
    protected void restoreValues() {
        for (Parameter parameter : this.paramList) {
            parameter.restoreParameterValues();
        }
    }

    @Override
    protected void acceptValues() {
        for (Parameter parameter : this.paramList) {
            parameter.acceptParameterValues();
        }
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getParameterValue(int n) {
        double d = 1.0;
        for (Parameter parameter : this.paramList) {
            d *= parameter.getParameterValue(n);
        }
        return d;
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getParameterName() {
        if (this.getId() == null) {
            StringBuilder stringBuilder = new StringBuilder("product");
            for (Parameter parameter : this.paramList) {
                stringBuilder.append(".").append(parameter.getId());
            }
            this.setId(stringBuilder.toString());
        }
        return this.getId();
    }

    @Override
    public void addBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    public Bounds<Double> getBounds() {
        if (this.bounds == null) {
            return this.paramList.get(0).getBounds();
        }
        return this.bounds;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireParameterChangedEvent(n, changeType);
    }
}

