/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.Intervals;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiTreeIntervals
extends AbstractModel
implements IntervalList {
    private final List<Tree> trees;
    private final Taxa singletonTaxa;
    private final boolean includeStems;
    private final double cutoffTime;
    private final Units.Type units;
    private Intervals intervals = null;
    private Intervals storedIntervals = null;
    private boolean eventsKnown = false;
    private boolean storedEventsKnown = false;

    public MultiTreeIntervals(Tree tree, boolean bl, double d) {
        super("MultiTreeIntervals");
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public MultiTreeIntervals(Collection<Tree> collection, Taxa taxa, boolean bl, double d) {
        super("MultiTreeIntervals");
        int n = 0;
        for (Tree tree : collection) {
            if (tree instanceof Model) {
                this.addModel((Model)((Object)tree));
            }
            n += tree.getNodeCount() + 1;
        }
        if (bl && taxa != null) {
            n += taxa.getTaxonCount() * 2;
        }
        this.trees = new ArrayList<Tree>(collection);
        this.singletonTaxa = taxa;
        this.includeStems = bl;
        this.cutoffTime = d;
        this.units = this.trees.get(0).getUnits();
        this.intervals = new Intervals(n);
        this.storedIntervals = new Intervals(n);
    }

    @Override
    public double getStartTime() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getStartTime();
    }

    @Override
    public int getSampleCount() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getSampleCount();
    }

    @Override
    public int getIntervalCount() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalCount();
    }

    @Override
    public double getInterval(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getInterval(n);
    }

    @Override
    public double getIntervalTime(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalTime(n);
    }

    @Override
    public int getLineageCount(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getLineageCount(n);
    }

    @Override
    public int getCoalescentEvents(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getCoalescentEvents(n);
    }

    @Override
    public IntervalType getIntervalType(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalType(n);
    }

    @Override
    public double getTotalDuration() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getTotalDuration();
    }

    @Override
    public boolean isBinaryCoalescent() {
        return this.intervals.isBinaryCoalescent();
    }

    @Override
    public boolean isCoalescentOnly() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.isCoalescentOnly();
    }

    @Override
    public void calculateIntervals() {
        this.intervals.resetEvents();
        for (Tree attributable : this.trees) {
            NodeRef nodeRef;
            int n;
            for (n = 0; n < attributable.getExternalNodeCount(); ++n) {
                nodeRef = attributable.getExternalNode(n);
                this.intervals.addSampleEvent(attributable.getNodeTaxon(nodeRef).getHeight());
            }
            for (n = 0; n < attributable.getInternalNodeCount(); ++n) {
                nodeRef = attributable.getInternalNode(n);
                this.intervals.addCoalescentEvent(attributable.getNodeHeight(nodeRef));
            }
            if (this.includeStems) {
                this.intervals.addNothingEvent(this.cutoffTime);
                continue;
            }
            NodeRef nodeRef2 = attributable.getInternalNode(attributable.getInternalNodeCount() - 1);
            this.intervals.addNothingEvent(attributable.getNodeHeight(nodeRef2));
        }
        if (this.includeStems && this.singletonTaxa != null) {
            for (Taxon taxon : this.singletonTaxa) {
                this.intervals.addSampleEvent(taxon.getHeight());
                this.intervals.addNothingEvent(this.cutoffTime);
            }
        }
        this.intervals.getIntervalCount();
        this.fireModelChanged();
        this.eventsKnown = true;
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public final void setUnits(Units.Type type) {
        throw new IllegalArgumentException("Can't set interval's units");
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.eventsKnown = false;
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedIntervals.copyIntervals(this.intervals);
        this.storedEventsKnown = this.eventsKnown;
    }

    @Override
    protected void restoreState() {
        Intervals intervals = this.storedIntervals;
        this.storedIntervals = this.intervals;
        this.intervals = intervals;
        this.eventsKnown = this.storedEventsKnown;
    }

    @Override
    protected void acceptState() {
    }
}

