/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class muStatistic
extends Statistic.Abstract
implements VariableListener {
    static int MAX_DIM = 30;
    private MatrixParameter mu;
    private TreeModel treeModel;
    private Parameter indicators;
    public static final String MU_STATISTIC = "muStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String MU_STRING = "mu";
        public static final String INDICATORS_STRING = "indicators";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule("mu", Parameter.class), new ElementRule("indicators", Parameter.class)};

        @Override
        public String getParserName() {
            return muStatistic.MU_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(MU_STRING);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(INDICATORS_STRING);
            return new muStatistic(treeModel, matrixParameter, parameter);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return muStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public muStatistic(TreeModel treeModel, MatrixParameter matrixParameter, Parameter parameter) {
        this.treeModel = treeModel;
        this.mu = matrixParameter;
        this.indicators = parameter;
        matrixParameter.addParameterListener(this);
        parameter.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return this.treeModel.getNodeCount() * 2;
    }

    @Override
    public double getStatisticValue(int n) {
        int n2 = n / 2;
        double d = this.mu.getParameter(n2).getParameterValue(n % 2);
        return d;
    }

    @Override
    public String getDimensionName(int n) {
        String string = "mu_" + n / 2 + "-" + (n % 2 + 1);
        return string;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

