/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc.obsolete;

import dr.evolution.io.Importer;
import dr.evolution.tree.FlexibleNode;
import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class TiterImporter
extends Importer {
    public static final String COMMENT = "comment";
    private String[] virusStrain;
    private String[] transformed_titer;
    private String[] titer;
    private Tree lastTree = null;

    public TiterImporter(Reader reader) {
        super(reader);
    }

    public TiterImporter(String string) {
        this(new StringReader(string));
    }

    public void readTiter(int n) throws IOException, Importer.ImportException {
        this.virusStrain = new String[n];
        this.transformed_titer = new String[n];
        this.titer = new String[n];
        this.readToken();
        this.readToken();
        this.readToken();
        this.readToken();
        for (int i = 0; i < n; ++i) {
            this.readInteger();
            this.virusStrain[i] = this.readToken();
            this.transformed_titer[i] = this.readToken();
            try {
                this.titer[i] = this.readLine();
                continue;
            }
            catch (EOFException eOFException) {
                System.out.println("err");
            }
        }
    }

    public String getVirusStrain(int n) {
        return this.virusStrain[n];
    }

    public String getTransformed_titer(int n) {
        return this.transformed_titer[n];
    }

    public String getTiter(int n) {
        return this.titer[n];
    }

    public Tree importTree(TaxonList taxonList) throws IOException, Importer.ImportException {
        this.setCommentDelimiters('[', ']', '\u0000', '\u0000', '&');
        try {
            this.skipUntil("(");
            this.unreadCharacter('(');
            FlexibleNode flexibleNode = this.readInternalNode(taxonList);
            if (this.getLastMetaComment() != null) {
                flexibleNode.setAttribute(COMMENT, this.getLastMetaComment());
            }
            return new FlexibleTree(flexibleNode, false, true);
        }
        catch (EOFException eOFException) {
            throw new Importer.ImportException("incomplete tree");
        }
    }

    public Tree[] importTrees(TaxonList taxonList) throws IOException, Importer.ImportException {
        Tree[] treeArray;
        boolean bl = false;
        ArrayList<FlexibleTree> arrayList = new ArrayList<FlexibleTree>();
        do {
            try {
                this.skipUntil("(");
                this.unreadCharacter('(');
                treeArray = this.readInternalNode(taxonList);
                FlexibleTree flexibleTree = new FlexibleTree((FlexibleNode)treeArray, false, true);
                arrayList.add(flexibleTree);
                if (taxonList == null) {
                    taxonList = flexibleTree;
                }
                if (this.readCharacter() != ';') {
                    throw new Importer.BadFormatException("Expecting ';' after tree");
                }
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        } while (!bl);
        treeArray = new Tree[arrayList.size()];
        arrayList.toArray(treeArray);
        return treeArray;
    }

    public boolean hasTree() throws IOException, Importer.ImportException {
        try {
            this.skipUntil("(");
            this.unreadCharacter('(');
        }
        catch (EOFException eOFException) {
            this.lastTree = null;
            return false;
        }
        return true;
    }

    public Tree importNextTree() throws IOException, Importer.ImportException {
        FlexibleTree flexibleTree = null;
        try {
            this.skipUntil("(");
            this.unreadCharacter('(');
            FlexibleNode flexibleNode = this.readInternalNode(this.lastTree);
            flexibleTree = new FlexibleTree(flexibleNode, false, true);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.lastTree = flexibleTree;
        return flexibleTree;
    }

    private FlexibleNode readBranch(TaxonList taxonList) throws IOException, Importer.ImportException {
        double d = 0.0;
        FlexibleNode flexibleNode = this.nextCharacter() == '(' ? this.readInternalNode(taxonList) : this.readExternalNode(taxonList);
        String string = this.getLastMetaComment();
        if (string != null) {
            flexibleNode.setAttribute(COMMENT, string);
            this.clearLastMetaComment();
        }
        if (this.getLastDelimiter() == 58) {
            d = this.readDouble(",():;");
        }
        flexibleNode.setLength(d);
        return flexibleNode;
    }

    private FlexibleNode readInternalNode(TaxonList taxonList) throws IOException, Importer.ImportException {
        FlexibleNode flexibleNode = new FlexibleNode();
        char c = this.readCharacter();
        assert (c == '(');
        flexibleNode.addChild(this.readBranch(taxonList));
        if (this.getLastDelimiter() != 44) {
            throw new Importer.BadFormatException("Expecting ',' in tree, but got '" + (char)this.getLastDelimiter() + "'");
        }
        do {
            flexibleNode.addChild(this.readBranch(taxonList));
        } while (this.getLastDelimiter() == 44);
        if (this.getLastDelimiter() != 41) {
            throw new Importer.BadFormatException("Missing closing ')' in tree");
        }
        try {
            String string = this.readToken(",():;");
            if (string.length() > 0) {
                flexibleNode.setAttribute("label", string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flexibleNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FlexibleNode readExternalNode(TaxonList taxonList) throws IOException, Importer.ImportException {
        Taxon taxon;
        FlexibleNode flexibleNode = new FlexibleNode();
        String string = this.readToken(":(),;");
        if (taxonList != null) {
            int n = taxonList.getTaxonIndex(string);
            if (n == -1) throw new Importer.UnknownTaxonException("Taxon in tree, '" + string + "' is unknown");
            taxon = taxonList.getTaxon(n);
        } else {
            taxon = new Taxon(string);
        }
        flexibleNode.setTaxon(taxon);
        return flexibleNode;
    }

    public class BranchMissingException
    extends Importer.ImportException {
        private static final long serialVersionUID = 777435104809244693L;

        public BranchMissingException() {
        }

        public BranchMissingException(String string) {
            super("Branch missing: " + string);
            System.err.println(string);
        }
    }
}

