/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.ClassifierPolQuadraticLMS;

import java.io.FileNotFoundException;
import java.io.IOException;
import keel.Algorithms.Shared.ClassicalOptim.GCQuad;
import keel.Algorithms.Shared.Parsing.ProcessConfig;
import keel.Algorithms.Shared.Parsing.ProcessDataset;
import keel.Algorithms.Statistical_Classifiers.Shared.DiscrAnalysis.AD;
import org.core.Randomize;

public class ClassifierPolQuadraticLMS {
    static Randomize rand;

    private static void quadraticClassifierLS(boolean tty, ProcessConfig pc) {
        try {
            int i;
            ProcessDataset pd = new ProcessDataset();
            String line = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processClassifierDataset(line, true);
            } else {
                pd.oldClusteringProcess(line);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            double[][] X = pd.getX();
            int[] C = pd.getC();
            int[] Ct = new int[C.length];
            int nClass = pd.getNclasses();
            pd.showDatasetStatistics();
            double[] maxInput = pd.getImaximum();
            double[] minInput = pd.getIminimum();
            int[] nInputFolds = new int[nInputs];
            double[][] Cbin = new double[nData][nClass];
            for (i = 0; i < nData; ++i) {
                Cbin[i][C[i]] = 1.0;
            }
            for (i = 0; i < X.length; ++i) {
                Ct[i] = -1;
            }
            int dimWeight = (nInputs * nInputs + nInputs) * nClass + nInputs + nClass;
            double[] weights = new double[dimWeight];
            GCQuad gcn = new GCQuad();
            double error = gcn.cuatrain(nInputs, nClass, X, Cbin, rand);
            double faults = 0.0;
            try {
                for (int i2 = 0; i2 < X.length; ++i2) {
                    double[] resp = gcn.cuaoutput(X[i2]);
                    int theClass = AD.argmax(resp);
                    if (theClass != C[i2]) {
                        faults += 1.0;
                    }
                    Ct[i2] = theClass;
                }
                System.out.println("Train error=" + (faults /= (double)nData));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            pc.trainingResults(C, Ct);
            ProcessDataset pdt = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(2);
            if (ProcessConfig.parNewFormat) {
                pdt.processClassifierDataset(line, false);
            } else {
                pdt.oldClusteringProcess(line);
            }
            int nTests = pdt.getNdata();
            int npVariables = pdt.getNvariables();
            int npInputs = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (npInputs != nInputs) {
                throw new IOException("IOERR test file");
            }
            double[][] Xp = pdt.getX();
            int[] Cp = pdt.getC();
            int[] Co = new int[Cp.length];
            try {
                faults = 0.0;
                for (int i3 = 0; i3 < Xp.length; ++i3) {
                    double[] resp = gcn.cuaoutput(Xp[i3]);
                    int theClass = AD.argmax(resp);
                    if (theClass != Cp[i3]) {
                        faults += 1.0;
                    }
                    Co[i3] = theClass;
                }
                System.out.println("Test error=" + (faults /= (double)Cp.length));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            pc.results(Cp, Co);
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Input file not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algo = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        ClassifierPolQuadraticLMS cp = new ClassifierPolQuadraticLMS();
        ClassifierPolQuadraticLMS.quadraticClassifierLS(tty, pc);
    }
}

