/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.regression;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Bounds;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.regression.RegressionInCyclops;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.metaAnalysis.DataModel;

public class CyclopsRegressionModel
extends AbstractModelLikelihood
implements DataModel {
    private final RegressionInCyclops cyclops;
    private final Parameter beta;
    private final int cyclopsDim;
    private final int cyclopsOffset;
    private double logLikelihood;
    private double storedLogLikelihood;
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnown;
    private boolean betaKnown;
    private boolean updateAllBeta;
    private final Queue<Integer> betaDimChanged = new LinkedList<Integer>();

    public CyclopsRegressionModel(String name, String libraryFileName, int instance, int dim, boolean useCyclopsStartingValue) {
        this(name, libraryFileName, instance, Analysis.makeParameter(String.valueOf(name) + ".beta", dim), useCyclopsStartingValue);
    }

    public CyclopsRegressionModel(String name, String libraryFileName, int instance, Parameter beta, boolean useCyclopsStartingValues) {
        super(name);
        this.cyclops = new RegressionInCyclops(libraryFileName, instance);
        this.beta = beta;
        this.cyclopsOffset = this.cyclops.hasOffset();
        this.cyclopsDim = this.cyclops.getBetaSize();
        if (beta.getDimension() != this.cyclopsDim - this.cyclopsOffset) {
            throw new IllegalArgumentException("Invalid beta parameter");
        }
        if (useCyclopsStartingValues) {
            this.setBetaParameterFromCyclops();
            this.betaKnown = true;
        } else {
            this.betaKnown = false;
        }
        this.updateAllBeta = false;
        this.addVariable((Variable)beta);
        beta.addBounds((Bounds)new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, beta.getDimension()));
    }

    public void findMode() {
        this.cyclops.findMode();
        this.setBetaParameterFromCyclops();
        this.betaKnown = true;
        this.likelihoodKnown = false;
    }

    private void setBetaParameterFromCyclops() {
        double[] values = new double[this.cyclopsDim];
        this.cyclops.getBeta(values);
        int i = 0;
        while (i < this.cyclopsDim - this.cyclopsOffset) {
            this.beta.setParameterValueQuietly(i, values[i + this.cyclopsOffset]);
            ++i;
        }
        this.beta.fireParameterChangedEvent();
    }

    protected void handleModelChangedEvent(Model model, Object o, int i) {
        throw new IllegalArgumentException("Unknown model");
    }

    protected void handleVariableChangedEvent(Variable variable, int index, Variable.ChangeType changeType) {
        if (variable == this.beta) {
            this.betaKnown = false;
            this.likelihoodKnown = false;
            if (changeType == Variable.ChangeType.ALL_VALUES_CHANGED) {
                this.updateAllBeta = true;
                this.betaDimChanged.clear();
            } else {
                this.betaDimChanged.add(index);
            }
        } else {
            throw new IllegalArgumentException("Unknown variable");
        }
    }

    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    protected void acceptState() {
    }

    public Model getModel() {
        return this;
    }

    public Parameter getParameter() {
        return this.beta;
    }

    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    private double calculateLogLikelihood() {
        if (!this.betaKnown) {
            this.setBetaInCyclops();
            this.betaKnown = true;
            this.updateAllBeta = false;
        }
        return this.cyclops.getLogLikelihood();
    }

    /*
     * Unable to fully structure code
     */
    private void setBetaInCyclops() {
        block3: {
            if (!this.updateAllBeta && !this.betaDimChanged.isEmpty()) ** GOTO lbl17
            values = this.beta.getParameterValues();
            if (this.cyclopsOffset > 0) {
                augmented = new double[this.cyclopsDim];
                i = 0;
                while (i < this.cyclopsOffset) {
                    augmented[i] = this.cyclops.getBeta(i);
                    ++i;
                }
                System.arraycopy(values, 0, augmented, this.cyclopsOffset, this.cyclopsDim - this.cyclopsOffset);
                values = augmented;
            }
            this.cyclops.setBeta(values);
            this.betaDimChanged.clear();
            break block3;
lbl-1000:
            // 1 sources

            {
                index = this.betaDimChanged.remove();
                this.cyclops.setBeta(index + this.cyclopsOffset, this.beta.getParameterValue(index));
lbl17:
                // 2 sources

                ** while (!this.betaDimChanged.isEmpty())
            }
        }
    }

    public void makeDirty() {
        this.likelihoodKnown = false;
        this.betaKnown = false;
        this.cyclops.makeDirty();
    }

    protected double[] getGradientWrtBeta() {
        double[] gradient = new double[this.cyclopsDim];
        this.cyclops.getLogLikelihoodGradient(gradient);
        return gradient;
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public Parameter getCompoundParameter() {
        return this.beta;
    }

    @Override
    public List<Parameter> getIndividualParameters() {
        return Collections.singletonList(this.beta);
    }

    @Override
    public List<Integer> getIdentifiers() {
        return null;
    }
}

