## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----example------------------------------------------------------------------
library("IVCor")
library("mvtnorm")
###The new IVC measure###
# linear model
n=100
x=rnorm(n)
y=3*x+rnorm(n)
IVC(y,x,K=5,type="linear")
# nonlinear model
n=100
p=3
x=matrix(NA,nrow=n,ncol=p)
for(i in 1:p){
  x[,i]=rnorm(n)
}
y=cos(x[,1]+x[,2])+x[,3]^2+rnorm(n)
IVC(y,x,K=5,type="nonlinear")
###Local linear estimation of IVC###
n=100
x=rnorm(n)
y=exp(x)+rnorm(n)
IVCLLQ(y,x,K=4)
###IVC measure with discrete response###
n=100
y=sample(rep(1:3), n, replace = TRUE, prob = c(1/3,1/3,1/3))
x=c()
for(i in 1:n){
  x[i]=rnorm(1,mean=2*y[i],sd=1)
}
IVCCA(y,x,K=5)
###IVC for interval independence###
n=100
p=3
pho1=0.5
mean_x=rep(0,p)
sigma_x=matrix(NA,nrow = p,ncol = p)
for (i in 1:p) {
  for (j in 1:p) {
    sigma_x[i,j]=pho1^(abs(i-j))
  }
}
x=rmvnorm(n, mean = mean_x, sigma = sigma_x,method = "chol")
y=2*(x[,1]+x[,2]+x[,3])+rnorm(n)
IVC_Interval(y,x,K=5,tau1=0.2,tau2=0.8,type="linear")
###IVC based hypothesis test###
n=100
p=4
x=matrix(NA,nrow=n,ncol=p)
for(i in 1:p){
  x[,i]=runif(n,0,1)
}
y=3*ifelse(x[,1]>0.5,1,0)*x[,2]+3*cos(x[,3])^2*x[,1]+3*(x[,4]^2-1)*x[,1]+rnorm(n)
IVCT(y,x,K=5,num_per=20,type = "nonlinear")
###Critical values for IVC based hypothesis test###
IVC_crit(N=500,realizations=100)
###IVC based hypothesis test for discrete response###
n=100
x=runif(n,0,1)
y=sample(rep(1:3), n, replace = TRUE, prob = c(1/3,1/3,1/3))
IVCCAT(y,x,K=5,num_per=20,type = "fixed")
###Critical values for IVC based hypothesis test with discrete response###
IVCCA_crit(R=5,N=500,realizations=100)
###IVC based interval independence hypothesis test###
n=100
p=3
pho1=0.5
mean_x=rep(0,p)
sigma_x=matrix(NA,nrow = p,ncol = p)
for (i in 1:p) {
  for (j in 1:p) {
    sigma_x[i,j]=pho1^(abs(i-j))
  }
}
x=rmvnorm(n, mean = mean_x, sigma = sigma_x,method = "chol")
y=rnorm(n)
IVCT_Interval(y,x,tau1=0.5,tau2=0.75,K=5,num_per=20,type = "linear")
n=100
x_til=runif(n,min=-1,max=1)
y_til=rnorm(n)
epsilon=rnorm(n)
x=x_til+2*epsilon*ifelse(x_til<=-0.5&y_til<=-0.675,1,0)
y=y_til+2*epsilon*ifelse(x_til<=-0.5&y_til<=-0.675,1,0)
IVCT_Interval(y,x,tau1=0.2,tau2=0.8,K=5,num_per=20,type = "nonlinear")


