/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.inference.jtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTree;
import org.eclipse.recommenders.jayes.inference.jtree.SepsetComputer;
import org.eclipse.recommenders.jayes.util.Graph;
import org.eclipse.recommenders.jayes.util.OrderIgnoringPair;
import org.eclipse.recommenders.jayes.util.Pair;
import org.eclipse.recommenders.jayes.util.triangulation.GraphElimination;
import org.eclipse.recommenders.jayes.util.triangulation.IEliminationHeuristic;

public class JunctionTreeBuilder {
    private final IEliminationHeuristic heuristic;

    public static JunctionTreeBuilder forHeuristic(IEliminationHeuristic heuristic) {
        return new JunctionTreeBuilder(heuristic);
    }

    protected JunctionTreeBuilder(IEliminationHeuristic heuristic) {
        this.heuristic = heuristic;
    }

    public JunctionTree buildJunctionTree(BayesNet net) {
        JunctionTree junctionTree = new JunctionTree();
        junctionTree.setClusters(this.triangulateGraphAndFindCliques(JunctionTreeBuilder.buildMoralGraph(net), this.weightNodesByOutcomes(net), this.heuristic));
        junctionTree.setSepSets(this.computeSepsets(junctionTree, net));
        return junctionTree;
    }

    public static Graph buildMoralGraph(BayesNet net) {
        Graph moral = new Graph(net.getNodes().size());
        for (BayesNode node : net.getNodes()) {
            JunctionTreeBuilder.addMoralEdges(moral, node);
        }
        return moral;
    }

    private static void addMoralEdges(Graph moral, BayesNode node) {
        ListIterator<BayesNode> it = node.getParents().listIterator();
        while (it.hasNext()) {
            BayesNode parent = it.next();
            ListIterator<BayesNode> remainingParentsIt = node.getParents().listIterator(it.nextIndex());
            while (remainingParentsIt.hasNext()) {
                BayesNode otherParent = remainingParentsIt.next();
                moral.addEdge(parent.getId(), otherParent.getId());
            }
            moral.addEdge(node.getId(), parent.getId());
        }
    }

    private List<List<Integer>> triangulateGraphAndFindCliques(Graph graph, double[] weights, IEliminationHeuristic eliminationHeuristic) {
        GraphElimination triangulate = new GraphElimination(graph, weights, eliminationHeuristic);
        ArrayList<List<Integer>> cliques = new ArrayList<List<Integer>>();
        for (List<Integer> nextClique : triangulate) {
            if (this.containsSuperset(cliques, nextClique)) continue;
            cliques.add(nextClique);
        }
        return cliques;
    }

    private double[] weightNodesByOutcomes(BayesNet net) {
        double[] weights = new double[net.getNodes().size()];
        for (BayesNode node : net.getNodes()) {
            weights[node.getId()] = Math.log(node.getOutcomeCount());
        }
        return weights;
    }

    private boolean containsSuperset(Collection<? extends Collection<Integer>> sets, Collection<Integer> set) {
        boolean isSubsetOfOther = false;
        for (Collection<Integer> collection : sets) {
            if (!collection.containsAll(set)) continue;
            isSubsetOfOther = true;
            break;
        }
        return isSubsetOfOther;
    }

    private List<Pair<OrderIgnoringPair<Integer>, List<Integer>>> computeSepsets(JunctionTree junctionTree, BayesNet net) {
        return new SepsetComputer().computeSepsets(junctionTree, net);
    }
}

