/*
 * Decompiled with CFR 0.152.
 */
package core.stats.scorer;

import core.model.DecomposableModel;
import core.model.GraphAction;
import core.model.PValueScoredGraphAction;
import core.model.ScoredGraphAction;
import core.stats.EntropyComputer;
import core.stats.scorer.GraphActionScorer;
import core.tools.ChiSquared;

public class GraphActionScorerPValue
extends GraphActionScorer {
    EntropyComputer entropyComputer;

    @Deprecated
    public GraphActionScorerPValue(int nbInstances, EntropyComputer entropyComputer) {
        this.entropyComputer = entropyComputer;
        this.nbInstances = nbInstances;
    }

    public GraphActionScorerPValue(EntropyComputer entropyComputer) {
        this.entropyComputer = entropyComputer;
        this.nbInstances = this.entropyComputer.getNbInstances();
    }

    @Override
    public ScoredGraphAction scoreEdge(DecomposableModel model, GraphAction action) {
        Double diffEntropy = model.entropyDiffIfAdding(action.getV1(), action.getV2(), this.entropyComputer);
        long dfDiff = model.nbParametersDiffIfAdding(action.getV1(), action.getV2());
        if (diffEntropy == null) {
            return new PValueScoredGraphAction(action.getType(), action.getV1(), action.getV2(), 1.0, dfDiff, Double.NaN);
        }
        double gDiff = 2.0 * (double)this.nbInstances * diffEntropy;
        double pValue = ChiSquared.pValue(gDiff, dfDiff);
        PValueScoredGraphAction scoredAction = new PValueScoredGraphAction(action.getType(), action.getV1(), action.getV2(), pValue, dfDiff, gDiff);
        return scoredAction;
    }
}

