/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.BrownianMotion;

public class BrownianMotionPCAEqualSteps
extends BrownianMotion {
    double dt;
    protected double[][] A;
    protected double[] z;
    protected boolean isDecompPCA = false;
    protected double[] sortedEigenvalues;

    public BrownianMotionPCAEqualSteps(double x0, double mu, double sigma, RandomStream stream) {
        super(x0, mu, sigma, stream);
    }

    public BrownianMotionPCAEqualSteps(double x0, double mu, double sigma, NormalGen gen) {
        super(x0, mu, sigma, gen);
    }

    public double nextObservation() {
        throw new UnsupportedOperationException("nextObservation() not defined for PCA.");
    }

    public double[] generatePath() {
        int j;
        if (!this.isDecompPCA) {
            this.init();
        }
        for (j = 0; j < this.d; ++j) {
            this.z[j] = this.gen.nextDouble();
        }
        for (j = 0; j < this.d; ++j) {
            double sum = 0.0;
            for (int k = 0; k < this.d; ++k) {
                sum += this.A[j][k] * this.z[k];
            }
            this.path[j + 1] = this.x0 + this.mu * this.t[j + 1] + sum;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] QMCpointsBM) {
        int j;
        if (!this.isDecompPCA) {
            this.init();
        }
        for (j = 0; j < this.d; ++j) {
            this.z[j] = NormalDist.inverseF01(QMCpointsBM[j]);
        }
        for (j = 0; j < this.d; ++j) {
            double sum = 0.0;
            for (int k = 0; k < this.d; ++k) {
                sum += this.A[j][k] * this.z[k];
            }
            this.path[j + 1] = this.x0 + this.mu * this.t[j + 1] + sum;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public void setObservationTimes(double[] t, int d) {
        super.setObservationTimes(t, d);
        this.dt = t[1] - t[0];
        for (int i = 1; i < d; ++i) {
            if (!(Math.abs((t[i + 1] - t[i]) / this.dt - 1.0) > 1.0E-7)) continue;
            throw new IllegalArgumentException("Not equidistant times");
        }
    }

    public void setObservationTimes(double dt, int d) {
        this.dt = dt;
        super.setObservationTimes(dt, d);
    }

    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            double twoOverSqrt2dP1 = 2.0 / Math.sqrt(2.0 * (double)this.d + 1.0);
            double piOver2dP1 = Math.PI / (2.0 * (double)this.d + 1.0);
            this.z = new double[this.d];
            this.A = new double[this.d][this.d];
            this.sortedEigenvalues = new double[this.d];
            for (int ic = 1; ic <= this.d; ++ic) {
                double tempSin = Math.sin((double)(2 * ic - 1) * piOver2dP1 / 2.0);
                this.sortedEigenvalues[ic - 1] = this.dt / 4.0 / tempSin / tempSin * this.sigma * this.sigma;
                for (int ir = 1; ir <= this.d; ++ir) {
                    this.A[ir - 1][ic - 1] = twoOverSqrt2dP1 * Math.sin((double)(2 * ic - 1) * piOver2dP1 * (double)ir);
                    double[] dArray = this.A[ir - 1];
                    int n = ic - 1;
                    dArray[n] = dArray[n] * Math.sqrt(this.sortedEigenvalues[ic - 1]);
                }
            }
            double[][] AA = new double[this.d][this.d];
            for (int ic = 0; ic < this.d; ++ic) {
                for (int ir = 0; ir < this.d; ++ir) {
                    double sum = 0.0;
                    for (int k = 0; k < this.d; ++k) {
                        sum += this.A[ir][k] * this.A[ic][k];
                    }
                    AA[ir][ic] = sum;
                }
            }
            this.isDecompPCA = true;
        }
    }

    public double[] getSortedEigenvalues() {
        return this.sortedEigenvalues;
    }
}

