/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.RayleighDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class RayleighGen
extends RandomVariateGen {
    private double a;
    private double beta;

    public RayleighGen(RandomStream s, double a, double beta) {
        super(s, new RayleighDist(a, beta));
        this.setParams(a, beta);
    }

    public RayleighGen(RandomStream s, double beta) {
        this(s, 0.0, beta);
    }

    public RayleighGen(RandomStream s, RayleighDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getA(), dist.getSigma());
        }
    }

    public static double nextDouble(RandomStream s, double a, double beta) {
        return RayleighDist.inverseF(a, beta, s.nextDouble());
    }

    public double getA() {
        return this.a;
    }

    public double getSigma() {
        return this.beta;
    }

    public void setParams(double a, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.a = a;
        this.beta = beta;
    }
}

