/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.probdist.InverseDistFromDensity;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ExponentialInverseFromDensityGen
extends ExponentialGen {
    public ExponentialInverseFromDensityGen(RandomStream stream, double lambda, double ueps, int order) {
        super(stream, lambda);
        double xc = Math.min(1.0, 0.5 / lambda);
        this.dist = new InverseDistFromDensity((ContinuousDistribution)this.dist, xc, ueps, order);
    }

    public ExponentialInverseFromDensityGen(RandomStream stream, ExponentialDist dist, double ueps, int order) {
        super(stream, dist);
        double xc = Math.min(1.0, 0.5 / this.lambda);
        this.dist = new InverseDistFromDensity(dist, xc, ueps, order);
    }

    public ExponentialInverseFromDensityGen(RandomStream stream, InverseDistFromDensity dist) {
        super(stream, null);
        this.lambda = -1.0;
        this.dist = dist;
    }

    public double getUepsilon() {
        return ((InverseDistFromDensity)this.dist).getEpsilon();
    }

    public int getOrder() {
        return ((InverseDistFromDensity)this.dist).getOrder();
    }
}

