/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.PoissonDist;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class ChiSquareNoncentralDist
extends ContinuousDistribution {
    protected static final int PREC = 15;
    protected static final double EPS = Num.TEN_NEG_POW[15];
    private static final double PROB_MIN = Double.MIN_VALUE / EPS;
    private static final boolean DETAIL = false;
    private static final double PARLIM = 1000.0;
    private double nu;
    private double lambda;
    private PoissonDist pois;
    private int jmin = -1;
    private int jmax = -1;

    private static double getXLIM(double nu, double lambda) {
        return 1600.0 + 20.0 * (nu + lambda);
    }

    private static int calcJmin(PoissonDist pois) {
        double sig;
        double lam = pois.getLambda();
        int j = (int)(lam - 7.0 * (sig = Math.sqrt(lam)));
        if (j < 0) {
            return 0;
        }
        while (j > 0 && pois.cdf(j) > EPS) {
            --j;
        }
        return j + 1;
    }

    private static int calcJmax(PoissonDist pois) {
        double lam = pois.getLambda();
        double sig = Math.sqrt(lam);
        int j = (int)(lam + 7.0 * sig);
        while (pois.barF(j) > EPS) {
            ++j;
        }
        return j - 1;
    }

    public ChiSquareNoncentralDist(double nu, double lambda) {
        this.setParams(nu, lambda);
    }

    public double density(double x) {
        return ChiSquareNoncentralDist.density(this.nu, this.lambda, x);
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= ChiSquareNoncentralDist.getXLIM(this.nu, this.lambda)) {
            return 1.0;
        }
        if (this.nu >= 1000.0 || this.lambda >= 1000.0) {
            return ChiSquareNoncentralDist.cdfPenev(false, this.nu, this.lambda, x);
        }
        return ChiSquareNoncentralDist.cdfExact(this.pois, this.jmax, this.nu, this.lambda, x);
    }

    public double barF(double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= ChiSquareNoncentralDist.getXLIM(this.nu, this.lambda)) {
            return 0.0;
        }
        if (this.nu >= 1000.0 || this.lambda >= 1000.0) {
            return ChiSquareNoncentralDist.cdfPenev(true, this.nu, this.lambda, x);
        }
        return ChiSquareNoncentralDist.barFExact(this.pois, this.jmin, this.nu, this.lambda, x);
    }

    public double inverseF(double u) {
        return ChiSquareNoncentralDist.inverseF(this.nu, this.lambda, u);
    }

    public double getMean() {
        return ChiSquareNoncentralDist.getMean(this.nu, this.lambda);
    }

    public double getVariance() {
        return ChiSquareNoncentralDist.getVariance(this.nu, this.lambda);
    }

    public double getStandardDeviation() {
        return ChiSquareNoncentralDist.getStandardDeviation(this.nu, this.lambda);
    }

    public static double density(double nu, double lambda, double x) {
        long j;
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (lambda == 0.0) {
            return GammaDist.density(nu / 2.0, 0.5, x);
        }
        if (x >= ChiSquareNoncentralDist.getXLIM(nu, lambda)) {
            return 0.0;
        }
        double a = 0.5 * nu - 1.0;
        double z = lambda * x;
        long JMAX = (long)(0.5 * z / (a + Math.sqrt(a * a + z)));
        double termMax = -0.5 * (x + lambda) + 0.25 * (nu - 2.0) * Math.log(x / lambda) + 0.5 * (a + (double)(2L * JMAX)) * Math.log(0.25 * x * lambda) - Num.lnFactorial(JMAX) - Num.lnGamma(a + (double)JMAX + 1.0) - 0.6931471805599453;
        double sum = termMax = Math.exp(termMax);
        double term = termMax;
        double y = 4.0 / z;
        for (j = JMAX; j > 0L && term > sum * EPS; --j) {
            sum += (term *= y * (double)j * ((double)j + a));
        }
        term = termMax;
        j = JMAX + 1L;
        y = z / 4.0;
        while (term > sum * EPS) {
            sum += (term *= y / ((double)j * ((double)j + a)));
            ++j;
        }
        return sum;
    }

    public static double cdf(double nu, double lambda, double x) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (lambda == 0.0) {
            return GammaDist.cdf(nu / 2.0, 0.5, 15, x);
        }
        if (x >= ChiSquareNoncentralDist.getXLIM(nu, lambda)) {
            return 1.0;
        }
        if (nu >= 1000.0 || lambda >= 1000.0) {
            return ChiSquareNoncentralDist.cdfPenev(false, nu, lambda, x);
        }
        PoissonDist pois = new PoissonDist(lambda / 2.0);
        int j = ChiSquareNoncentralDist.calcJmax(pois);
        return ChiSquareNoncentralDist.cdfExact(pois, j, nu, lambda, x);
    }

    private static double cdfExact(PoissonDist pois, int jmax, double nu, double lambda, double x) {
        int JMED = (int)(lambda / 2.0);
        int j = jmax;
        double chicdf = GammaDist.cdf((double)j + 0.5 * nu, 0.5, 15, x);
        if (chicdf >= 1.0) {
            return 1.0;
        }
        double chiterm = x / ((double)j + 0.5 * nu) * GammaDist.density((double)j + 0.5 * nu, 0.5, x);
        double prob = pois.prob(j);
        double sum = prob * chicdf;
        --j;
        while (j >= 0 && (prob > sum * EPS || j >= JMED)) {
            if (chicdf <= PROB_MIN) {
                chicdf = GammaDist.cdf((double)j + nu / 2.0, 0.5, 15, x);
                chiterm = x / ((double)j + 0.5 * nu) * GammaDist.density((double)j + nu / 2.0, 0.5, x);
            } else {
                chicdf += (chiterm *= ((double)(2 + 2 * j) + nu) / x);
            }
            if (chicdf >= 1.0 - EPS) {
                return sum + pois.cdf(j);
            }
            prob = pois.prob(j);
            sum += prob * chicdf;
            --j;
        }
        return sum;
    }

    private static double cdfPearson(boolean bar, double nu, double lambda, double x) {
        double t2 = nu + 2.0 * lambda;
        double t3 = nu + 3.0 * lambda;
        double lib = t2 * t2 * t2 / (t3 * t3);
        double z = x + lambda * lambda / t3;
        if (bar) {
            return GammaDist.barF(lib / 2.0, 0.5, 15, t2 * z / t3);
        }
        return GammaDist.cdf(lib / 2.0, 0.5, 15, t2 * z / t3);
    }

    private static double penevH(double y) {
        if (0.0 == y) {
            return 0.0;
        }
        if (1.0 == y) {
            return 0.5;
        }
        return ((1.0 - y) * Math.log1p(-y) + y - 0.5 * y * y) / (y * y);
    }

    private static double penevB(double mu, double s, double h1) {
        double f = 1.0 + 2.0 * mu * s;
        double g = 1.0 + 3.0 * mu * s;
        double c = (f - 2.0 * h1 - s * f) / (f - 2.0 * h1);
        double B = -1.5 * (1.0 + 4.0 * mu * s) / (f * f);
        B += 5.0 * g * g / (3.0 * f * f * f) + 2.0 * g / ((s - 1.0) * f * f);
        B += 3.0 * c / ((s - 1.0) * (s - 1.0) * f);
        return B -= c * c * (1.0 + 2.0 * ChiSquareNoncentralDist.penevH(c)) / (2.0 * (s - 1.0) * (s - 1.0) * f);
    }

    private static double getPenevLim(double nu, double lam) {
        if (lam >= 100000.0) {
            return 5.0;
        }
        if (nu >= 20000.0) {
            return 3.0;
        }
        return 2.0;
    }

    private static double cdfPenev(boolean bar, double nu, double lambda, double x) {
        double mean = nu + lambda;
        double lim = ChiSquareNoncentralDist.getPenevLim(nu, lambda);
        if (x >= mean - lim && x <= mean + lim) {
            return ChiSquareNoncentralDist.cdfPearson(bar, nu, lambda, x);
        }
        double mu = lambda / nu;
        double s = (Math.sqrt(1.0 + 4.0 * x * mu / nu) - 1.0) / (2.0 * mu);
        if (s == 1.0) {
            return 0.5;
        }
        double h1 = ChiSquareNoncentralDist.penevH(1.0 - s);
        double B = ChiSquareNoncentralDist.penevB(mu, s, h1);
        double f = 1.0 + 2.0 * mu * s;
        double z = nu * (s - 1.0) * (s - 1.0) * (0.5 / s + mu - h1 / s) - Math.log(1.0 / s - 2.0 * h1 / (s * f)) + 2.0 * B / nu;
        if (z < 0.0 || z != z) {
            return ChiSquareNoncentralDist.cdfPearson(bar, nu, lambda, x);
        }
        z = Math.sqrt(z);
        if (s < 1.0) {
            z = -z;
        }
        if (bar) {
            return NormalDist.barF01(z);
        }
        return NormalDist.cdf01(z);
    }

    public static double barF(double nu, double lambda, double x) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        if (lambda == 0.0) {
            return GammaDist.barF(nu / 2.0, 0.5, 15, x);
        }
        if (x >= ChiSquareNoncentralDist.getXLIM(nu, lambda)) {
            return 0.0;
        }
        if (nu >= 1000.0 || lambda >= 1000.0) {
            return ChiSquareNoncentralDist.cdfPenev(true, nu, lambda, x);
        }
        PoissonDist pois = new PoissonDist(lambda / 2.0);
        int j = ChiSquareNoncentralDist.calcJmin(pois);
        return ChiSquareNoncentralDist.barFExact(pois, j, nu, lambda, x);
    }

    private static double barFExact(PoissonDist pois, int jmin, double nu, double lambda, double x) {
        int JMED = (int)(lambda / 2.0);
        int j = jmin;
        double chibar = GammaDist.barF((double)j + 0.5 * nu, 0.5, 15, x);
        if (chibar >= 1.0) {
            return 1.0;
        }
        double prob = pois.prob(j);
        double sum = prob * chibar;
        double chiterm = 2.0 * GammaDist.density((double)j + 0.5 * nu, 0.5, x);
        ++j;
        while (prob > sum * EPS || j <= JMED) {
            if (chibar <= PROB_MIN) {
                chibar = GammaDist.barF((double)j + nu / 2.0, 0.5, 15, x);
                chiterm = 2.0 * GammaDist.density((double)j + 0.5 * nu, 0.5, x);
            } else {
                chibar += (chiterm *= x / ((double)(2 * j - 2) + nu));
            }
            if (chibar >= 1.0) {
                return sum + pois.barF(j);
            }
            prob = pois.prob(j);
            sum += prob * chibar;
            ++j;
        }
        return sum;
    }

    public static double inverseF(double nu, double lambda, double u) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (lambda == 0.0) {
            return GammaDist.inverseF(nu / 2.0, 0.5, 15, u);
        }
        double x = ChiSquareNoncentralDist.inverse9(nu, lambda, u);
        double v = ChiSquareNoncentralDist.cdf(nu, lambda, x);
        Function f = new Function(nu, lambda, u);
        if (v >= u) {
            x = RootFinder.brentDekker(0.0, x, f, 1.0E-10);
        } else {
            v = ChiSquareNoncentralDist.getXLIM(nu, lambda);
            x = RootFinder.brentDekker(x, v, f, 1.0E-10);
        }
        return x;
    }

    private static double inverse9(double nu, double lambda, double u) {
        double z = NormalDist.inverseF01(u);
        double a = nu + lambda;
        double b = (nu + 2.0 * lambda) / (a * a);
        double t = z * Math.sqrt(2.0 * b / 9.0) - 2.0 * b / 9.0 + 1.0;
        return a * t * t * t;
    }

    public static double getMean(double nu, double lambda) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return nu + lambda;
    }

    public static double getVariance(double nu, double lambda) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 2.0 * (nu + 2.0 * lambda);
    }

    public static double getStandardDeviation(double nu, double lambda) {
        return Math.sqrt(ChiSquareNoncentralDist.getVariance(nu, lambda));
    }

    public double getNu() {
        return this.nu;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double nu, double lambda) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (lambda == 0.0) {
            throw new IllegalArgumentException("lambda = 0");
        }
        this.nu = nu;
        this.lambda = lambda;
        this.supportA = 0.0;
        if (nu >= 1000.0 || lambda >= 1000.0) {
            return;
        }
        this.pois = new PoissonDist(lambda / 2.0);
        this.jmax = ChiSquareNoncentralDist.calcJmax(this.pois);
        this.jmin = ChiSquareNoncentralDist.calcJmin(this.pois);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.nu, this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":   nu = " + this.nu + ",   lambda = " + this.lambda;
    }

    private static class Function
    implements MathFunction {
        protected double nu;
        protected double lambda;
        protected double u;

        public Function(double nu, double lambda, double u) {
            this.nu = nu;
            this.lambda = lambda;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - ChiSquareNoncentralDist.cdf(this.nu, this.lambda, x);
        }
    }
}

