/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.util;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.act.rscat.util.ContentTable;
import org.act.rscat.util.PrimitiveArrays;
import org.apache.commons.lang3.ArrayUtils;

public class PrimitiveArraySet {
    private final Map<String, Object> arrays;
    private final int length;

    public PrimitiveArraySet() {
        this(new HashMap<String, Object>(), 0);
    }

    private PrimitiveArraySet(Map<String, Object> arrays, int length) {
        this.arrays = arrays;
        this.length = length;
    }

    public static PrimitiveArraySet fromContentTable(ContentTable table, Map<String, Class<?>> columnTypes) {
        ContentTable.ColumnOriented colTable = table.orientByColumns();
        HashMap<String, Object> arrays = new HashMap<String, Object>();
        for (Map.Entry<String, Class<?>> entry : columnTypes.entrySet()) {
            String colName = entry.getKey();
            Class<?> colType = entry.getValue();
            Object array = PrimitiveArraySet.convert(colTable.columnValues(colTable.columnIndex(colName)), colType);
            arrays.put(colName, array);
        }
        return new PrimitiveArraySet(arrays, table.rowCount());
    }

    public PrimitiveArraySet withIntArray(String arrayId, int[] array) {
        return this.withArray(arrayId, array, array.length);
    }

    public int[] getIntArray(String arrayIdentifier) {
        return this.getArray(arrayIdentifier, int[].class);
    }

    public int[] getIntArrayCopy(String arrayIdentifier) {
        int[] intArray = this.getArray(arrayIdentifier, int[].class);
        if (intArray != null) {
            int[] intArrayCopy = new int[intArray.length];
            System.arraycopy(intArray, 0, intArrayCopy, 0, intArray.length);
            return intArrayCopy;
        }
        return intArray;
    }

    public PrimitiveArraySet withDoubleArray(String arrayId, double[] array) {
        return this.withArray(arrayId, array, array.length);
    }

    public double[] getDoubleArray(String arrayIdentifier) {
        return this.getArray(arrayIdentifier, double[].class);
    }

    public double[] getDoubleArrayCopy(String arrayIdentifier) {
        double[] doubleArray = this.getArray(arrayIdentifier, double[].class);
        if (doubleArray != null) {
            double[] doubleArrayCopy = new double[doubleArray.length];
            System.arraycopy(doubleArray, 0, doubleArrayCopy, 0, doubleArray.length);
            return doubleArrayCopy;
        }
        return doubleArray;
    }

    public PrimitiveArraySet withBooleanArray(String arrayId, boolean[] array) {
        return this.withArray(arrayId, array, array.length);
    }

    public boolean[] getBooleanArray(String arrayIdentifier) {
        return this.getArray(arrayIdentifier, boolean[].class);
    }

    public boolean[] getBooleanArrayCopy(String arrayIdentifier) {
        boolean[] booleanArray = this.getArray(arrayIdentifier, boolean[].class);
        if (booleanArray != null) {
            boolean[] booleanArrayCopy = new boolean[booleanArray.length];
            System.arraycopy(booleanArray, 0, booleanArrayCopy, 0, booleanArray.length);
            return booleanArrayCopy;
        }
        return booleanArray;
    }

    public PrimitiveArraySet withStringArray(String arrayId, String[] array) {
        return this.withArray(arrayId, array, array.length);
    }

    public String[] getStringArray(String arrayIdentifier) {
        return this.getArray(arrayIdentifier, String[].class);
    }

    public String[] getStringArrayCopy(String arrayIdentifier) {
        String[] stringArray = this.getArray(arrayIdentifier, String[].class);
        if (stringArray != null) {
            String[] stringArrayCopy = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArrayCopy, 0, stringArray.length);
            return stringArrayCopy;
        }
        return stringArray;
    }

    public PrimitiveArraySet without(String arrayIdentifier) {
        HashMap<String, Object> newArrays = new HashMap<String, Object>(this.arrays);
        newArrays.remove(arrayIdentifier);
        int newLength = newArrays.isEmpty() ? 0 : this.length;
        return new PrimitiveArraySet(newArrays, newLength);
    }

    public PrimitiveArraySet subset(int startIndex, int endIndex) {
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("invalid subset");
        }
        HashMap<String, Object> newArrays = new HashMap<String, Object>();
        this.arrays.entrySet().forEach(array -> newArrays.put((String)array.getKey(), PrimitiveArraySet.subset(array.getValue(), startIndex, endIndex)));
        int newLength = endIndex - startIndex;
        return new PrimitiveArraySet(newArrays, newLength);
    }

    public PrimitiveArraySet subSample(int ... indices) {
        HashMap<String, Object> newArrays = new HashMap<String, Object>();
        this.arrays.entrySet().forEach(array -> newArrays.put((String)array.getKey(), PrimitiveArraySet.subSample(array.getValue(), indices)));
        int newLength = indices.length;
        return new PrimitiveArraySet(newArrays, newLength);
    }

    public Set<String> arrayIds() {
        return this.arrays.keySet();
    }

    public int length() {
        return this.length;
    }

    public PrimitiveArraySet groupSort(String arrayId) {
        Object arrayObject = this.arrays.get(arrayId);
        Comparator<Integer> comparator = PrimitiveArraySet.indexComparator(arrayObject);
        List<Integer> indexes = IntStream.range(0, this.length).boxed().collect(Collectors.toList());
        Collections.sort(indexes, comparator);
        return this.groupSort(indexes);
    }

    public PrimitiveArraySet reverse() {
        List<Integer> indexes = IntStream.iterate(this.length - 1, value -> value - 1).limit(this.length).boxed().collect(Collectors.toList());
        return this.groupSort(indexes);
    }

    private PrimitiveArraySet groupSort(List<Integer> indexes) {
        HashMap<String, Object> sortedArrays = new HashMap<String, Object>(this.arrays.size());
        this.arrays.entrySet().forEach(array -> sortedArrays.put((String)array.getKey(), PrimitiveArraySet.sort(array.getValue(), indexes)));
        return new PrimitiveArraySet(sortedArrays, this.length);
    }

    private <T> T getArray(String arrayIdentifier, Class<T> arrayType) {
        return arrayType.cast(this.arrays.get(arrayIdentifier));
    }

    private PrimitiveArraySet withArray(String arrayId, Object array, int aLength) {
        if (!this.arrays.isEmpty() && this.length != aLength) {
            throw new IllegalArgumentException("Cannot add array of length " + aLength + " to set of length " + this.length);
        }
        HashMap<String, Object> newArrays = new HashMap<String, Object>(this.arrays);
        newArrays.put(arrayId, array);
        return new PrimitiveArraySet(newArrays, aLength);
    }

    private static Object convert(List<String> values, Class<?> arrayType) {
        return ArrayTypes.support(arrayType).convert(values);
    }

    private static Comparator<Integer> indexComparator(Object array) {
        return ArrayTypes.support(array.getClass()).indexComparator(array);
    }

    private static Object sort(Object array, List<Integer> indices) {
        return ArrayTypes.support(array.getClass()).sort(array, indices);
    }

    private static Object subset(Object array, int startIndex, int endIndex) {
        return ArrayTypes.support(array.getClass()).subset(array, startIndex, endIndex);
    }

    private static Object subSample(Object array, int ... indices) {
        return ArrayTypes.support(array.getClass()).subSample(array, indices);
    }

    private static interface ArraySupport {
        public Object convert(List<String> var1);

        public Comparator<Integer> indexComparator(Object var1);

        public Object sort(Object var1, List<Integer> var2);

        public Object subset(Object var1, int var2, int var3);

        public Object subSample(Object var1, int ... var2);
    }

    private static enum ArrayTypes {
        INT(int[].class, new ArraySupport(){

            @Override
            public Object convert(List<String> stringValues) {
                return PrimitiveArrays.intArray(stringValues);
            }

            @Override
            public Comparator<Integer> indexComparator(Object arrayObject) {
                int[] array = (int[])arrayObject;
                return (o1, o2) -> Integer.compare(array[o1], array[o2]);
            }

            @Override
            public Object sort(Object arrayObject, List<Integer> indices) {
                int[] array = (int[])arrayObject;
                return indices.stream().mapToInt(index -> array[index]).toArray();
            }

            @Override
            public Object subset(Object arrayObject, int startIndex, int endIndex) {
                return ArrayUtils.subarray((int[])((int[])arrayObject), (int)startIndex, (int)endIndex);
            }

            @Override
            public Object subSample(Object arrayObject, int ... indices) {
                int[] array = (int[])arrayObject;
                return IntStream.of(indices).map(index -> array[index]).toArray();
            }
        }),
        DOUBLE(double[].class, new ArraySupport(){

            @Override
            public Object convert(List<String> stringValues) {
                return PrimitiveArrays.doubleArray(stringValues);
            }

            @Override
            public Comparator<Integer> indexComparator(Object arrayObject) {
                double[] array = (double[])arrayObject;
                return (o1, o2) -> Double.compare(array[o1], array[o2]);
            }

            @Override
            public Object sort(Object arrayObject, List<Integer> indices) {
                double[] array = (double[])arrayObject;
                return indices.stream().mapToDouble(index -> array[index]).toArray();
            }

            @Override
            public Object subset(Object arrayObject, int startIndex, int endIndex) {
                return ArrayUtils.subarray((double[])((double[])arrayObject), (int)startIndex, (int)endIndex);
            }

            @Override
            public Object subSample(Object arrayObject, int ... indices) {
                double[] array = (double[])arrayObject;
                return IntStream.of(indices).mapToDouble(index -> array[index]).toArray();
            }
        }),
        BOOLEAN(boolean[].class, new ArraySupport(){

            @Override
            public Object convert(List<String> stringValues) {
                return PrimitiveArrays.booleanArray(stringValues);
            }

            @Override
            public Comparator<Integer> indexComparator(Object arrayObject) {
                boolean[] array = (boolean[])arrayObject;
                return (o1, o2) -> Boolean.compare(array[o1], array[o2]);
            }

            @Override
            public Object sort(Object arrayObject, List<Integer> indices) {
                Iterator<Integer> indexIterator = indices.iterator();
                boolean[] array = (boolean[])arrayObject;
                boolean[] copy = new boolean[array.length];
                for (int i = 0; i < copy.length; ++i) {
                    copy[i] = array[indexIterator.next()];
                }
                return copy;
            }

            @Override
            public Object subset(Object arrayObject, int startIndex, int endIndex) {
                return ArrayUtils.subarray((boolean[])((boolean[])arrayObject), (int)startIndex, (int)endIndex);
            }

            @Override
            public Object subSample(Object arrayObject, int ... indices) {
                boolean[] array = (boolean[])arrayObject;
                boolean[] sample = new boolean[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    sample[i] = array[indices[i]];
                }
                return sample;
            }
        }),
        STRING(String[].class, new ArraySupport(){

            @Override
            public Object convert(List<String> stringValues) {
                return stringValues.toArray(new String[stringValues.size()]);
            }

            @Override
            public Comparator<Integer> indexComparator(Object arrayObject) {
                String[] array = (String[])arrayObject;
                return (o1, o2) -> array[o1].compareTo(array[o2]);
            }

            @Override
            public Object sort(Object arrayObject, List<Integer> indices) {
                String[] array = (String[])arrayObject;
                return indices.stream().map(index -> array[index]).toArray(String[]::new);
            }

            @Override
            public Object subset(Object arrayObject, int startIndex, int endIndex) {
                return ArrayUtils.subarray((Object[])((String[])arrayObject), (int)startIndex, (int)endIndex);
            }

            @Override
            public Object subSample(Object arrayObject, int ... indices) {
                String[] array = (String[])arrayObject;
                return IntStream.of(indices).mapToObj(index -> array[index]).toArray(String[]::new);
            }
        });

        private Class<?> arrayType;
        private ArraySupport support;

        private ArrayTypes(Class<?> arrayType, ArraySupport support) {
            this.arrayType = arrayType;
            this.support = support;
        }

        static ArraySupport support(Class<?> arrayType) {
            return Stream.of(ArrayTypes.values()).filter((Predicate<ArrayTypes>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$support$0(java.lang.Class org.act.rscat.util.PrimitiveArraySet$ArrayTypes ), (Lorg/act/rscat/util/PrimitiveArraySet$ArrayTypes;)Z)(arrayType)).findAny().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$support$1(java.lang.Class ), ()Ljava/lang/IllegalArgumentException;)(arrayType)).support;
        }

        private static /* synthetic */ IllegalArgumentException lambda$support$1(Class arrayType) {
            return new IllegalArgumentException("Unsupported type: " + arrayType);
        }

        private static /* synthetic */ boolean lambda$support$0(Class arrayType, ArrayTypes type) {
            return type.arrayType.equals(arrayType);
        }
    }
}

