/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCManager {
    public static Connection connectToDatabase(Properties properties) throws SQLException {
        Connection connection = null;
        String string = properties.getProperty("jdbc.jndi-name");
        if (string != null) {
            try {
                InitialContext initialContext = new InitialContext();
                connection = ((DataSource)initialContext.lookup(string)).getConnection();
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException("The jdbc.jndi-name property refers to the invalid name " + string);
            }
        }
        String string2 = properties.getProperty("jdbc.driver");
        String string3 = properties.getProperty("jdbc.uri");
        if (string3 != null) {
            if (string2 != null) {
                try {
                    Class<?> clazz = Class.forName(string2);
                    if (!Driver.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException("The driver name " + string2 + " does not correspond to a class implementing the java.sql.Driver interface");
                    }
                    clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Could not find the driver class " + string2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("An illegal access prevented the instantiation of driver class " + string2);
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalArgumentException("An instantiation exception prevented the instantiation of driver class " + string2 + ": " + instantiationException.getMessage());
                }
            }
            connection = DriverManager.getConnection(string3);
        } else {
            throw new IllegalArgumentException("The jdbc.driver and jdbc.uri properties must be given if jdbc.jndi-name is not set");
        }
        return connection;
    }

    public static Connection connectToDatabase(InputStream inputStream) throws IOException, SQLException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return JDBCManager.connectToDatabase(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connectToDatabase(URL uRL) throws IOException, SQLException {
        InputStream inputStream = uRL.openStream();
        try {
            Connection connection = JDBCManager.connectToDatabase(inputStream);
            return connection;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connectToDatabase(File file) throws IOException, SQLException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Connection connection = JDBCManager.connectToDatabase(fileInputStream);
            return connection;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connectToDatabase(String string) throws IOException, SQLException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            Connection connection = JDBCManager.connectToDatabase(fileInputStream);
            return connection;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connectToDatabaseFromResource(String string) throws IOException, SQLException {
        InputStream inputStream = JDBCManager.class.getClassLoader().getResourceAsStream(string);
        try {
            Connection connection = JDBCManager.connectToDatabase(inputStream);
            return connection;
        }
        finally {
            inputStream.close();
        }
    }

    public static double[] readDoubleData(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.last();
        double[] dArray = new double[resultSet.getRow()];
        resultSet.first();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = resultSet.getDouble(1);
            resultSet.next();
        }
        resultSet.close();
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readDoubleData(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement(1004, 1007);
        try {
            double[] dArray = JDBCManager.readDoubleData(statement, string);
            return dArray;
        }
        finally {
            statement.close();
        }
    }

    public static double[] readDoubleData(Statement statement, String string, String string2) throws SQLException {
        String string3 = "SELECT " + string2 + " FROM " + string;
        return JDBCManager.readDoubleData(statement, string3);
    }

    public static double[] readDoubleData(Connection connection, String string, String string2) throws SQLException {
        String string3 = "SELECT " + string2 + " FROM " + string;
        return JDBCManager.readDoubleData(connection, string3);
    }

    public static int[] readIntData(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.last();
        int[] nArray = new int[resultSet.getRow()];
        resultSet.first();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = resultSet.getInt(1);
            resultSet.next();
        }
        resultSet.close();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntData(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement(1004, 1007);
        try {
            int[] nArray = JDBCManager.readIntData(statement, string);
            return nArray;
        }
        finally {
            statement.close();
        }
    }

    public static int[] readIntData(Statement statement, String string, String string2) throws SQLException {
        String string3 = "SELECT " + string2 + " FROM " + string;
        return JDBCManager.readIntData(statement, string3);
    }

    public static int[] readIntData(Connection connection, String string, String string2) throws SQLException {
        String string3 = "SELECT " + string2 + " FROM " + string;
        return JDBCManager.readIntData(connection, string3);
    }

    public static Object[] readObjectData(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.last();
        Object[] objectArray = new Object[resultSet.getRow()];
        resultSet.first();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = resultSet.getObject(1);
            resultSet.next();
        }
        resultSet.close();
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] readObjectData(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement(1004, 1007);
        try {
            Object[] objectArray = JDBCManager.readObjectData(statement, string);
            return objectArray;
        }
        finally {
            statement.close();
        }
    }

    public static Object[] readObjectData(Statement statement, String string, String string2) throws SQLException {
        String string3 = "SELECT " + string2 + " FROM " + string;
        return JDBCManager.readObjectData(statement, string3);
    }

    public static Object[] readObjectData(Connection connection, String string, String string2) throws SQLException {
        String string3 = "SELECT " + string2 + " FROM " + string;
        return JDBCManager.readObjectData(connection, string3);
    }

    public static double[][] readDoubleData2D(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.last();
        int n = resultSet.getMetaData().getColumnCount();
        double[][] dArray = new double[resultSet.getRow()][n];
        resultSet.first();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray[i][j] = resultSet.getDouble(1 + j);
            }
            resultSet.next();
        }
        resultSet.close();
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] readDoubleData2D(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement(1004, 1007);
        try {
            double[][] dArray = JDBCManager.readDoubleData2D(statement, string);
            return dArray;
        }
        finally {
            statement.close();
        }
    }

    public static double[][] readDoubleData2DTable(Statement statement, String string) throws SQLException {
        String string2 = "SELECT * FROM " + string;
        return JDBCManager.readDoubleData2D(statement, string2);
    }

    public static double[][] readDoubleData2DTable(Connection connection, String string) throws SQLException {
        String string2 = "SELECT * FROM " + string;
        return JDBCManager.readDoubleData2D(connection, string2);
    }

    public static int[][] readIntData2D(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.last();
        int n = resultSet.getMetaData().getColumnCount();
        int[][] nArray = new int[resultSet.getRow()][n];
        resultSet.first();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray[i][j] = resultSet.getInt(1 + j);
            }
            resultSet.next();
        }
        resultSet.close();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readIntData2D(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement(1004, 1007);
        try {
            int[][] nArray = JDBCManager.readIntData2D(statement, string);
            return nArray;
        }
        finally {
            statement.close();
        }
    }

    public static int[][] readIntData2DTable(Statement statement, String string) throws SQLException {
        String string2 = "SELECT * FROM " + string;
        return JDBCManager.readIntData2D(statement, string2);
    }

    public static int[][] readIntData2DTable(Connection connection, String string) throws SQLException {
        String string2 = "SELECT * FROM " + string;
        return JDBCManager.readIntData2D(connection, string2);
    }

    public static Object[][] readObjectData2D(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.last();
        int n = resultSet.getMetaData().getColumnCount();
        Object[][] objectArray = new Object[resultSet.getRow()][n];
        resultSet.first();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[i].length; ++j) {
                objectArray[i][j] = resultSet.getObject(1 + j);
            }
            resultSet.next();
        }
        resultSet.close();
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[][] readObjectData2D(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement(1004, 1007);
        try {
            Object[][] objectArray = JDBCManager.readObjectData2D(statement, string);
            return objectArray;
        }
        finally {
            statement.close();
        }
    }

    public static Object[][] readObjectData2DTable(Statement statement, String string) throws SQLException {
        String string2 = "SELECT * FROM " + string;
        return JDBCManager.readObjectData2D(statement, string2);
    }

    public static Object[][] readObjectData2DTable(Connection connection, String string) throws SQLException {
        String string2 = "SELECT * FROM " + string;
        return JDBCManager.readObjectData2D(connection, string2);
    }
}

