/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import umontreal.iro.lecuyer.simevents.Continuous;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Simulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousState {
    private double stepSize;
    private IntegMethod integMethod;
    private int order;
    private double[] A = new double[4];
    private double[] B = new double[4];
    private double[] C = new double[4];
    private StepEvent stepEv = null;
    private List<Continuous> list = new ArrayList<Continuous>();
    private Simulator sim;

    protected ContinuousState(Simulator simulator) {
        this.sim = simulator;
        assert (simulator != null);
    }

    public List<Continuous> getContinuousVariables() {
        return Collections.unmodifiableList(this.list);
    }

    protected void startInteg(Continuous continuous) {
        if (this.stepEv == null) {
            this.stepEv = new StepEvent(this.sim);
        }
        continuous.active = true;
        if (this.list.isEmpty()) {
            this.stepEv.schedule(this.stepSize);
        }
        this.list.add(continuous);
    }

    protected void stopInteg(Continuous continuous) {
        continuous.active = false;
        this.list.remove(continuous);
        if (this.list.isEmpty()) {
            this.stepEv.cancel();
        }
    }

    public IntegMethod integMethod() {
        return this.integMethod;
    }

    public void selectEuler(double d) {
        this.integMethod = IntegMethod.EULER;
        this.stepSize = d;
    }

    public void selectRungeKutta2(double d) {
        this.integMethod = IntegMethod.RUNGEKUTTA2;
        this.stepSize = d;
        this.order = 2;
        this.A[0] = 1.0;
        this.A[1] = 0.0;
        this.B[0] = 0.5;
        this.B[1] = 0.5;
        this.C[0] = 0.0;
        this.C[1] = 1.0;
    }

    public void selectRungeKutta4(double d) {
        this.integMethod = IntegMethod.RUNGEKUTTA4;
        this.stepSize = d;
        this.order = 4;
        this.A[0] = 0.5;
        this.A[1] = 0.5;
        this.A[2] = 1.0;
        this.A[3] = 0.0;
        this.B[0] = 0.16666666666666666;
        this.B[1] = 0.3333333333333333;
        this.B[2] = 0.3333333333333333;
        this.B[3] = 0.16666666666666666;
        this.C[0] = 0.0;
        this.C[1] = 0.5;
        this.C[2] = 0.5;
        this.C[3] = 1.0;
    }

    private void oneStepEuler() {
        Continuous continuous;
        double d = this.sim.time() - this.stepSize;
        int n = this.list.size();
        while (n > 0) {
            continuous = this.list.get(--n);
            continuous.phi = continuous.value + this.stepSize * continuous.derivative(d);
        }
        n = this.list.size();
        while (n > 0) {
            continuous = this.list.get(--n);
            continuous.value = continuous.phi;
            if (continuous.ev != null) {
                continuous.ev.scheduleNext();
            }
            continuous.afterEachStep();
        }
    }

    private void oneStepRK() {
        Continuous continuous;
        double d = this.sim.time() - this.stepSize;
        int n = this.list.size();
        while (n > 0) {
            continuous = this.list.get(--n);
            continuous.buffer = continuous.value;
            continuous.sum = 0.0;
            continuous.pi = 0.0;
        }
        for (int i = 1; i <= this.order - 1; ++i) {
            n = this.list.size();
            while (n > 0) {
                continuous = this.list.get(--n);
                continuous.pi = continuous.derivative(d + this.stepSize * this.C[i - 1]);
                continuous.sum += continuous.pi * this.B[i - 1];
                continuous.phi = continuous.buffer + this.stepSize * continuous.pi * this.A[i - 1];
            }
            n = this.list.size();
            while (n > 0) {
                continuous = this.list.get(--n);
                continuous.value = continuous.phi;
            }
        }
        n = this.list.size();
        while (n > 0) {
            continuous = this.list.get(--n);
            continuous.pi = continuous.derivative(d + this.stepSize * this.C[this.order - 1]);
            continuous.value = continuous.buffer + this.stepSize * (continuous.sum + continuous.pi * this.B[this.order - 1]);
            if (continuous.ev != null) {
                continuous.ev.scheduleNext();
            }
            continuous.afterEachStep();
        }
    }

    private class StepEvent
    extends Event {
        public StepEvent(Simulator simulator) {
            super(simulator);
        }

        public void actions() {
            switch (ContinuousState.this.integMethod) {
                case EULER: {
                    ContinuousState.this.oneStepEuler();
                    break;
                }
                case RUNGEKUTTA2: {
                    ContinuousState.this.oneStepRK();
                    break;
                }
                case RUNGEKUTTA4: {
                    ContinuousState.this.oneStepRK();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Integration step with undefined method");
                }
            }
            this.schedule(ContinuousState.this.stepSize);
        }

        public String toString() {
            return "Integration step for continuous variable ";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntegMethod {
        EULER,
        RUNGEKUTTA2,
        RUNGEKUTTA4;

    }
}

