# ***********************************************************
# calcFib:
#   Compute Fibonacci numbers iteratively using a .C call to
#   C code
# Arguments:
#   n   - final nth fibonacci number to calculate
#   len - length of output vector with previous fibonacci numbers
# -----------------------------------------------------------
calcFib <- function(n, len=1) {
  if (n<0) return(NA)
  if (len>n) len <- n
  retArr <- numeric(len)
  out <- .C("fibonacci", as.integer(n), as.integer(len),
            as.numeric(retArr), PACKAGE="PBStry")
  x <- out[[3]]
  return(x) }
