/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.CrossoverGUI;
import org.mutoss.gui.options.OptionsDialog;
import org.mutoss.gui.options.OptionsPanel;
import org.mutoss.gui.options.SetLookAndFeelException;

public class OutputPanel
extends OptionsPanel
implements ActionListener {
    private static final Log logger = LogFactory.getLog(OutputPanel.class);
    private Configuration conf;
    private OptionsDialog odialog;
    private JCheckBox showCarryOver;
    private JCheckBox showNames;
    private JComboBox showTable = new JComboBox<String>(new String[]{"HTML Table", "ASCII", "R matrix"});
    String[] outputF = new String[]{"HTML", "ASCII", "R"};
    CrossoverGUI parent;

    public OutputPanel(CrossoverGUI parent, OptionsDialog odialog) {
        this.conf = Configuration.getInstance();
        this.odialog = odialog;
        this.parent = parent;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.showCarryOver = new JCheckBox("Show variances of pairwise carry-over comparisons.");
        String f = this.conf.getProperty("outputF", "HTML");
        for (int i = 0; i < this.outputF.length; ++i) {
            if (!f.equals(this.outputF[i])) continue;
            this.showTable.setSelectedIndex(i);
        }
        this.showCarryOver.setToolTipText("<html></html>");
        this.showCarryOver.setSelected(Boolean.parseBoolean(this.conf.getProperty("showCarryOver", "false")));
        this.showNames = new JCheckBox("Show row and column names.");
        this.showNames.setSelected(Boolean.parseBoolean(this.conf.getProperty("showNames", "true")));
    }

    private void doTheLayout() {
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)new JLabel("Show design as: "), cc.xy(1, row));
        p1.add((Component)this.showTable, cc.xy(3, row));
        p1.add((Component)this.showCarryOver, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.showNames, cc.xyw(1, row += 2, 3));
        row += 2;
        this.add(p1);
    }

    public void setProperties() throws SetLookAndFeelException {
        this.conf.setProperty("outputF", this.outputF[this.showTable.getSelectedIndex()]);
        this.conf.setProperty("showCarryOver", "" + this.showCarryOver.isSelected());
        this.conf.setProperty("showNames", "" + this.showNames.isSelected());
    }

    public void actionPerformed(ActionEvent e) {
    }
}

