# load the sample data
set.seed(123)
data(dat, package = "ecic")

# true results ----
ecic1_known <-
  structure(list(list(coefs = structure(list(perc = c(
    0.1, 0.2,
    0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20652792828688,
    1.32026946246403, 1.45963570967079, 1.59069481166298, 1.74650314077746,
    1.92208039132979, 2.12770961519026, 2.37146765883249, 2.78821611280866
  )), class = "data.frame", row.names = c(NA, -9L)), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3288L, 3288L,
      3288L, 3288L, 3288L, 3288L, 3288L, 3288L, 3288L, 3288L, 3406L,
      3406L, 3406L, 3406L, 3406L, 3406L, 3406L, 3406L, 3406L, 3406L,
      3406L, 3406L, 3314L, 3314L, 3314L, 3314L, 3314L, 3314L, 3314L,
      3314L, 3314L, 3270L, 3270L, 3270L, 3270L
    ), n0 = c(
      3406L,
      3314L, 3314L, 3270L, 3270L, 3270L, 3432L, 3432L, 3432L, 3432L,
      3314L, 3314L, 3270L, 3270L, 3270L, 3270L, 3432L, 3432L, 3432L,
      3432L, 3432L, 3432L, 3270L, 3270L, 3270L, 3432L, 3432L, 3432L,
      3432L, 3432L, 3432L, 3432L, 3432L, 3432L, 3432L
    )
  ), class = "data.frame", row.names = c(
    NA,
    -35L
  )))), class = "ecic", ecic = list(myProbs = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), es = FALSE, periods_es = NA))
ecic1a_known <-
  structure(list(list(coefs = structure(list(perc = c(
    0.1, 0.2,
    0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.19157703423353,
    1.32424773233639, 1.47080625365283, 1.61557450411822, 1.77360068479517,
    1.94383524685349, 2.12881130764858, 2.37821990612436, 2.81219797320025
  )), class = "data.frame", row.names = c(NA, -9L)), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3375L, 3375L,
      3319L, 3375L, 3319L, 3290L, 3375L, 3319L, 3290L, 3331L, 3424L,
      3444L, 3424L, 3444L, 3430L, 3450L, 3424L, 3444L, 3430L, 3450L,
      3370L, 3390L, 3308L, 3322L, 3265L, 3308L, 3322L, 3265L, 3242L,
      3256L, 3199L, 3199L, 3241L, 3214L, 3220L
    ), n0 = c(
      3450L,
      3292L, 3235L, 3310L, 3283L, 3289L, 3525L, 3481L, 3434L, 3389L,
      3235L, 3249L, 3283L, 3325L, 3289L, 3331L, 3481L, 3506L, 3434L,
      3459L, 3389L, 3414L, 3289L, 3331L, 3304L, 3434L, 3459L, 3415L,
      3389L, 3414L, 3370L, 3389L, 3414L, 3370L, 3323L
    )
  ), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.21531715187261, 1.31376352835213,
    1.44220350792541, 1.59845798641708, 1.72430610611493, 1.89001002904547,
    2.10451632866234, 2.37547866868556, 2.77156072023765
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3286L, 3286L, 3272L, 3286L, 3272L,
    3305L, 3286L, 3272L, 3305L, 3231L, 3390L, 3416L, 3390L, 3416L,
    3461L, 3487L, 3390L, 3416L, 3461L, 3487L, 3416L, 3442L, 3297L,
    3322L, 3291L, 3297L, 3322L, 3291L, 3347L, 3372L, 3341L, 3271L,
    3291L, 3237L, 3316L
  ), n0 = c(
    3482L, 3297L, 3266L, 3294L, 3240L,
    3319L, 3445L, 3398L, 3359L, 3400L, 3266L, 3291L, 3240L, 3260L,
    3319L, 3339L, 3398L, 3473L, 3359L, 3434L, 3400L, 3475L, 3319L,
    3339L, 3285L, 3359L, 3434L, 3387L, 3400L, 3475L, 3428L, 3400L,
    3475L, 3428L, 3389L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20343064877587, 1.31942017560451,
    1.47434606291007, 1.59807492657724, 1.73440139049935, 1.90264806686778,
    2.12461305451868, 2.37435649572452, 2.7667552891026
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3371L, 3371L, 3354L, 3371L, 3354L,
    3398L, 3371L, 3354L, 3398L, 3305L, 3514L, 3501L, 3514L, 3501L,
    3423L, 3410L, 3514L, 3501L, 3423L, 3410L, 3444L, 3431L, 3239L,
    3150L, 3218L, 3239L, 3150L, 3218L, 3312L, 3223L, 3291L, 3279L,
    3208L, 3211L, 3268L
  ), n0 = c(
    3507L, 3259L, 3327L, 3229L, 3232L,
    3289L, 3491L, 3494L, 3448L, 3512L, 3327L, 3238L, 3232L, 3161L,
    3289L, 3218L, 3494L, 3425L, 3448L, 3379L, 3512L, 3443L, 3289L,
    3218L, 3221L, 3448L, 3379L, 3382L, 3512L, 3443L, 3446L, 3512L,
    3443L, 3446L, 3400L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.24837746399535, 1.3537945155019,
    1.4765165454892, 1.59620285531372, 1.74573031405763, 1.89706946687012,
    2.10337116166401, 2.36534584707072, 2.79196001254307
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3267L, 3267L, 3154L, 3267L, 3154L,
    3167L, 3267L, 3154L, 3167L, 3249L, 3475L, 3470L, 3475L, 3470L,
    3425L, 3420L, 3475L, 3470L, 3425L, 3420L, 3447L, 3442L, 3316L,
    3307L, 3352L, 3316L, 3307L, 3352L, 3345L, 3336L, 3381L, 3205L,
    3145L, 3205L, 3204L
  ), n0 = c(
    3467L, 3289L, 3334L, 3228L, 3288L,
    3287L, 3444L, 3500L, 3494L, 3421L, 3334L, 3325L, 3288L, 3228L,
    3287L, 3227L, 3500L, 3482L, 3494L, 3476L, 3421L, 3403L, 3287L,
    3227L, 3287L, 3494L, 3476L, 3532L, 3421L, 3403L, 3459L, 3421L,
    3403L, 3459L, 3453L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20960108911721, 1.31966715599942,
    1.45313362045787, 1.58797917315569, 1.73849926776262, 1.92119596322944,
    2.13360027256538, 2.38729914620019, 2.80165902221522
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3357L, 3357L, 3344L, 3357L, 3344L,
    3396L, 3357L, 3344L, 3396L, 3295L, 3363L, 3359L, 3363L, 3359L,
    3488L, 3484L, 3363L, 3359L, 3488L, 3484L, 3395L, 3391L, 3303L,
    3344L, 3319L, 3303L, 3344L, 3319L, 3364L, 3405L, 3380L, 3236L,
    3225L, 3263L, 3190L
  ), n0 = c(
    3352L, 3329L, 3304L, 3285L, 3323L,
    3250L, 3418L, 3505L, 3424L, 3436L, 3304L, 3345L, 3323L, 3312L,
    3250L, 3239L, 3505L, 3479L, 3424L, 3398L, 3436L, 3410L, 3250L,
    3239L, 3277L, 3424L, 3398L, 3485L, 3436L, 3410L, 3497L, 3436L,
    3410L, 3497L, 3416L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  )))), class = "ecic", ecic = list(myProbs = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), es = FALSE, periods_es = NA))
ecic7_known <-
  structure(list(list(coefs = structure(list(perc = c(
    0.1, 0.2,
    0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.1824369447982,
    1.30594712799754, 1.44788201220285, 1.57524422238064, 1.73282094342383,
    1.9304999353308, 2.12586499417866, 2.35883364987528, 2.8009323109267
  )), class = "data.frame", row.names = c(NA, -9L)), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3256L, 3256L,
      3335L, 3256L, 3335L, 3229L, 3256L, 3335L, 3229L, 3248L, 3533L,
      3567L, 3533L, 3567L, 3409L, 3443L, 3533L, 3567L, 3409L, 3443L,
      3405L, 3439L, 3237L, 3290L, 3260L, 3237L, 3290L, 3260L, 3327L,
      3380L, 3350L, 3252L, 3182L, 3246L, 3268L
    ), n0 = c(
      3454L,
      3287L, 3257L, 3192L, 3256L, 3278L, 3569L, 3600L, 3517L, 3557L,
      3257L, 3310L, 3256L, 3186L, 3278L, 3208L, 3600L, 3547L, 3517L,
      3464L, 3557L, 3504L, 3278L, 3208L, 3272L, 3517L, 3464L, 3495L,
      3557L, 3504L, 3535L, 3557L, 3504L, 3535L, 3452L
    )
  ), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.21211450808513, 1.32192289778635,
    1.45054568362979, 1.6010617387931, 1.75289039645421, 1.90632098312348,
    2.09853291789222, 2.36162264162246, 2.75940471599269
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3167L, 3167L, 3205L, 3167L, 3205L,
    3261L, 3167L, 3205L, 3261L, 3289L, 3455L, 3433L, 3455L, 3433L,
    3491L, 3469L, 3455L, 3433L, 3491L, 3469L, 3463L, 3441L, 3372L,
    3302L, 3280L, 3372L, 3302L, 3280L, 3286L, 3216L, 3194L, 3168L,
    3198L, 3191L, 3197L
  ), n0 = c(
    3386L, 3352L, 3330L, 3160L, 3153L,
    3159L, 3484L, 3583L, 3533L, 3553L, 3330L, 3260L, 3153L, 3183L,
    3159L, 3189L, 3583L, 3543L, 3533L, 3493L, 3553L, 3513L, 3159L,
    3189L, 3182L, 3533L, 3493L, 3592L, 3553L, 3513L, 3612L, 3553L,
    3513L, 3612L, 3562L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.22386742415163, 1.32192778428336,
    1.45146140213719, 1.57393999285736, 1.73408320200945, 1.90985173366415,
    2.12050083621721, 2.36885790619949, 2.77726880747783
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3223L, 3223L, 3201L, 3223L, 3201L,
    3292L, 3223L, 3201L, 3292L, 3285L, 3469L, 3424L, 3469L, 3424L,
    3486L, 3441L, 3469L, 3424L, 3486L, 3441L, 3487L, 3442L, 3410L,
    3349L, 3275L, 3410L, 3349L, 3275L, 3319L, 3258L, 3184L, 3245L,
    3195L, 3160L, 3205L
  ), n0 = c(
    3423L, 3347L, 3273L, 3244L, 3209L,
    3254L, 3637L, 3550L, 3445L, 3546L, 3273L, 3212L, 3209L, 3159L,
    3254L, 3204L, 3550L, 3663L, 3445L, 3558L, 3546L, 3659L, 3254L,
    3204L, 3169L, 3445L, 3558L, 3471L, 3546L, 3659L, 3572L, 3546L,
    3659L, 3572L, 3467L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20251453089042, 1.32763655158287,
    1.46050749552387, 1.59309443746446, 1.73259855133304, 1.89612677428077,
    2.12077243736671, 2.36314193635842, 2.77728723373902
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3244L, 3244L, 3246L, 3244L, 3246L,
    3305L, 3244L, 3246L, 3305L, 3254L, 3586L, 3540L, 3586L, 3540L,
    3453L, 3407L, 3586L, 3540L, 3453L, 3407L, 3465L, 3419L, 3314L,
    3198L, 3283L, 3314L, 3198L, 3283L, 3336L, 3220L, 3305L, 3155L,
    3144L, 3195L, 3220L
  ), n0 = c(
    3546L, 3242L, 3327L, 3165L, 3216L,
    3241L, 3472L, 3473L, 3450L, 3500L, 3327L, 3211L, 3216L, 3205L,
    3241L, 3230L, 3473L, 3597L, 3450L, 3574L, 3500L, 3624L, 3241L,
    3230L, 3281L, 3450L, 3574L, 3575L, 3500L, 3624L, 3625L, 3500L,
    3624L, 3625L, 3602L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.23268751747993, 1.36278011635359,
    1.48827976042445, 1.62405385456238, 1.76550419499753, 1.93336328649018,
    2.13273981952176, 2.38884959816939, 2.77689580924945
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3286L, 3286L, 3312L, 3286L, 3312L,
    3240L, 3286L, 3312L, 3240L, 3203L, 3513L, 3475L, 3513L, 3475L,
    3533L, 3495L, 3513L, 3475L, 3533L, 3495L, 3493L, 3455L, 3349L,
    3307L, 3318L, 3349L, 3307L, 3318L, 3296L, 3254L, 3265L, 3133L,
    3136L, 3136L, 3183L
  ), n0 = c(
    3502L, 3294L, 3305L, 3119L, 3119L,
    3166L, 3537L, 3543L, 3535L, 3588L, 3305L, 3263L, 3119L, 3122L,
    3166L, 3169L, 3543L, 3532L, 3535L, 3524L, 3588L, 3577L, 3166L,
    3169L, 3169L, 3535L, 3524L, 3530L, 3588L, 3577L, 3583L, 3588L,
    3577L, 3583L, 3575L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.24723132729876, 1.30296233148013,
    1.45336816788703, 1.58936756686391, 1.75624650124266, 1.9294788239147,
    2.13051868876053, 2.38328618600855, 2.78056591765925
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3123L, 3123L, 3257L, 3123L, 3257L,
    3187L, 3123L, 3257L, 3187L, 3244L, 3436L, 3472L, 3436L, 3472L,
    3367L, 3403L, 3436L, 3472L, 3367L, 3403L, 3561L, 3597L, 3292L,
    3334L, 3274L, 3292L, 3334L, 3274L, 3287L, 3329L, 3269L, 3216L,
    3229L, 3225L, 3241L
  ), n0 = c(
    3456L, 3306L, 3246L, 3175L, 3171L,
    3187L, 3426L, 3448L, 3470L, 3552L, 3246L, 3288L, 3171L, 3184L,
    3187L, 3200L, 3448L, 3426L, 3470L, 3448L, 3552L, 3530L, 3187L,
    3200L, 3196L, 3470L, 3448L, 3470L, 3552L, 3530L, 3552L, 3552L,
    3530L, 3552L, 3574L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20135085050734, 1.31217409986284,
    1.43508516658777, 1.59546305020047, 1.7593335261447, 1.94530423598744,
    2.13272840261082, 2.38439095017226, 2.81365911580339
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3278L, 3278L, 3251L, 3278L, 3251L,
    3316L, 3278L, 3251L, 3316L, 3220L, 3365L, 3437L, 3365L, 3437L,
    3382L, 3454L, 3365L, 3437L, 3382L, 3454L, 3385L, 3457L, 3315L,
    3301L, 3324L, 3315L, 3301L, 3324L, 3318L, 3304L, 3327L, 3150L,
    3210L, 3172L, 3150L
  ), n0 = c(
    3422L, 3332L, 3355L, 3192L, 3154L,
    3132L, 3513L, 3504L, 3512L, 3591L, 3355L, 3341L, 3154L, 3214L,
    3132L, 3192L, 3504L, 3525L, 3512L, 3533L, 3591L, 3612L, 3132L,
    3192L, 3154L, 3512L, 3533L, 3524L, 3591L, 3612L, 3603L, 3591L,
    3612L, 3603L, 3611L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.1937902555922, 1.317703373204,
    1.45203915067927, 1.57280887824339, 1.74447150744163, 1.91566306288656,
    2.11670950011645, 2.37322355320513, 2.79332083514464
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3284L, 3284L, 3328L, 3284L, 3328L,
    3352L, 3284L, 3328L, 3352L, 3333L, 3523L, 3457L, 3523L, 3457L,
    3567L, 3501L, 3523L, 3457L, 3567L, 3501L, 3524L, 3458L, 3119L,
    3182L, 3212L, 3119L, 3182L, 3212L, 3281L, 3344L, 3374L, 3124L,
    3131L, 3080L, 3096L
  ), n0 = c(
    3516L, 3241L, 3271L, 3189L, 3138L,
    3154L, 3601L, 3516L, 3470L, 3477L, 3271L, 3334L, 3138L, 3145L,
    3154L, 3161L, 3516L, 3637L, 3470L, 3591L, 3477L, 3598L, 3154L,
    3161L, 3110L, 3470L, 3591L, 3506L, 3477L, 3598L, 3513L, 3477L,
    3598L, 3513L, 3467L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.19290162757717, 1.30151664759906,
    1.44091273169976, 1.56021425752034, 1.7103189507626, 1.89281372388963,
    2.10076323397715, 2.33983917525469, 2.76359452728019
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3282L, 3282L, 3166L, 3282L, 3166L,
    3297L, 3282L, 3166L, 3297L, 3298L, 3489L, 3490L, 3489L, 3490L,
    3424L, 3425L, 3489L, 3490L, 3424L, 3425L, 3449L, 3450L, 3312L,
    3395L, 3305L, 3312L, 3395L, 3305L, 3217L, 3300L, 3210L, 3175L,
    3123L, 3163L, 3201L
  ), n0 = c(
    3479L, 3359L, 3269L, 3150L, 3190L,
    3228L, 3471L, 3522L, 3588L, 3523L, 3269L, 3352L, 3190L, 3138L,
    3228L, 3176L, 3522L, 3535L, 3588L, 3601L, 3523L, 3536L, 3228L,
    3176L, 3216L, 3588L, 3601L, 3652L, 3523L, 3536L, 3587L, 3523L,
    3536L, 3587L, 3653L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.26641098784249, 1.36672707297392,
    1.50262295509157, 1.62323490957891, 1.7846913266483, 1.95875979874468,
    2.16224859205934, 2.40278784685807, 2.83102380887894
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3226L, 3226L, 3234L, 3226L, 3234L,
    3176L, 3226L, 3234L, 3176L, 3242L, 3422L, 3480L, 3422L, 3480L,
    3390L, 3448L, 3422L, 3480L, 3390L, 3448L, 3370L, 3428L, 3204L,
    3307L, 3198L, 3204L, 3307L, 3198L, 3296L, 3399L, 3290L, 3164L,
    3203L, 3078L, 3114L
  ), n0 = c(
    3448L, 3313L, 3204L, 3297L, 3172L,
    3208L, 3544L, 3456L, 3491L, 3517L, 3204L, 3307L, 3172L, 3211L,
    3208L, 3247L, 3456L, 3532L, 3491L, 3567L, 3517L, 3593L, 3208L,
    3247L, 3122L, 3491L, 3567L, 3479L, 3517L, 3593L, 3505L, 3517L,
    3593L, 3505L, 3540L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  )))), class = "ecic", ecic = list(myProbs = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), es = FALSE, periods_es = NA))

ecic8_known <-
  structure(list(list(coefs = structure(list(perc = c(
    0.1, 0.2,
    0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.19157703423353,
    1.32424773233639, 1.47080625365283, 1.61557450411822, 1.77360068479517,
    1.94383524685349, 2.12881130764858, 2.37821990612436, 2.81219797320025
  )), class = "data.frame", row.names = c(NA, -9L)), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3375L, 3375L,
      3319L, 3375L, 3319L, 3290L, 3375L, 3319L, 3290L, 3331L, 3424L,
      3444L, 3424L, 3444L, 3430L, 3450L, 3424L, 3444L, 3430L, 3450L,
      3370L, 3390L, 3308L, 3322L, 3265L, 3308L, 3322L, 3265L, 3242L,
      3256L, 3199L, 3199L, 3241L, 3214L, 3220L
    ), n0 = c(
      3450L,
      3292L, 3235L, 3310L, 3283L, 3289L, 3525L, 3481L, 3434L, 3389L,
      3235L, 3249L, 3283L, 3325L, 3289L, 3331L, 3481L, 3506L, 3434L,
      3459L, 3389L, 3414L, 3289L, 3331L, 3304L, 3434L, 3459L, 3415L,
      3389L, 3414L, 3370L, 3389L, 3414L, 3370L, 3323L
    )
  ), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.21531715187261, 1.31376352835213,
    1.44220350792541, 1.59845798641708, 1.72430610611493, 1.89001002904547,
    2.10451632866234, 2.37547866868556, 2.77156072023765
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3286L, 3286L, 3272L, 3286L, 3272L,
    3305L, 3286L, 3272L, 3305L, 3231L, 3390L, 3416L, 3390L, 3416L,
    3461L, 3487L, 3390L, 3416L, 3461L, 3487L, 3416L, 3442L, 3297L,
    3322L, 3291L, 3297L, 3322L, 3291L, 3347L, 3372L, 3341L, 3271L,
    3291L, 3237L, 3316L
  ), n0 = c(
    3482L, 3297L, 3266L, 3294L, 3240L,
    3319L, 3445L, 3398L, 3359L, 3400L, 3266L, 3291L, 3240L, 3260L,
    3319L, 3339L, 3398L, 3473L, 3359L, 3434L, 3400L, 3475L, 3319L,
    3339L, 3285L, 3359L, 3434L, 3387L, 3400L, 3475L, 3428L, 3400L,
    3475L, 3428L, 3389L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20343064877587, 1.31942017560451,
    1.47434606291007, 1.59807492657724, 1.73440139049935, 1.90264806686778,
    2.12461305451868, 2.37435649572452, 2.7667552891026
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3371L, 3371L, 3354L, 3371L, 3354L,
    3398L, 3371L, 3354L, 3398L, 3305L, 3514L, 3501L, 3514L, 3501L,
    3423L, 3410L, 3514L, 3501L, 3423L, 3410L, 3444L, 3431L, 3239L,
    3150L, 3218L, 3239L, 3150L, 3218L, 3312L, 3223L, 3291L, 3279L,
    3208L, 3211L, 3268L
  ), n0 = c(
    3507L, 3259L, 3327L, 3229L, 3232L,
    3289L, 3491L, 3494L, 3448L, 3512L, 3327L, 3238L, 3232L, 3161L,
    3289L, 3218L, 3494L, 3425L, 3448L, 3379L, 3512L, 3443L, 3289L,
    3218L, 3221L, 3448L, 3379L, 3382L, 3512L, 3443L, 3446L, 3512L,
    3443L, 3446L, 3400L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.24837746399535, 1.3537945155019,
    1.4765165454892, 1.59620285531372, 1.74573031405763, 1.89706946687012,
    2.10337116166401, 2.36534584707072, 2.79196001254307
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3267L, 3267L, 3154L, 3267L, 3154L,
    3167L, 3267L, 3154L, 3167L, 3249L, 3475L, 3470L, 3475L, 3470L,
    3425L, 3420L, 3475L, 3470L, 3425L, 3420L, 3447L, 3442L, 3316L,
    3307L, 3352L, 3316L, 3307L, 3352L, 3345L, 3336L, 3381L, 3205L,
    3145L, 3205L, 3204L
  ), n0 = c(
    3467L, 3289L, 3334L, 3228L, 3288L,
    3287L, 3444L, 3500L, 3494L, 3421L, 3334L, 3325L, 3288L, 3228L,
    3287L, 3227L, 3500L, 3482L, 3494L, 3476L, 3421L, 3403L, 3287L,
    3227L, 3287L, 3494L, 3476L, 3532L, 3421L, 3403L, 3459L, 3421L,
    3403L, 3459L, 3453L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20960108911721, 1.31966715599942,
    1.45313362045787, 1.58797917315569, 1.73849926776262, 1.92119596322944,
    2.13360027256538, 2.38729914620019, 2.80165902221522
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3357L, 3357L, 3344L, 3357L, 3344L,
    3396L, 3357L, 3344L, 3396L, 3295L, 3363L, 3359L, 3363L, 3359L,
    3488L, 3484L, 3363L, 3359L, 3488L, 3484L, 3395L, 3391L, 3303L,
    3344L, 3319L, 3303L, 3344L, 3319L, 3364L, 3405L, 3380L, 3236L,
    3225L, 3263L, 3190L
  ), n0 = c(
    3352L, 3329L, 3304L, 3285L, 3323L,
    3250L, 3418L, 3505L, 3424L, 3436L, 3304L, 3345L, 3323L, 3312L,
    3250L, 3239L, 3505L, 3479L, 3424L, 3398L, 3436L, 3410L, 3250L,
    3239L, 3277L, 3424L, 3398L, 3485L, 3436L, 3410L, 3497L, 3436L,
    3410L, 3497L, 3416L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20690272407849, 1.33074192541802,
    1.47615618594869, 1.61276368815535, 1.77600702630549, 1.94520100632876,
    2.1424251271198, 2.39120771311504, 2.77773538558121
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3358L, 3358L, 3250L, 3358L, 3250L,
    3332L, 3358L, 3250L, 3332L, 3280L, 3411L, 3399L, 3411L, 3399L,
    3415L, 3403L, 3411L, 3399L, 3415L, 3403L, 3409L, 3397L, 3339L,
    3342L, 3338L, 3339L, 3342L, 3338L, 3332L, 3335L, 3331L, 3360L,
    3243L, 3272L, 3300L
  ), n0 = c(
    3370L, 3343L, 3339L, 3281L, 3310L,
    3338L, 3500L, 3435L, 3432L, 3409L, 3339L, 3342L, 3310L, 3193L,
    3338L, 3221L, 3435L, 3439L, 3432L, 3436L, 3409L, 3413L, 3338L,
    3221L, 3250L, 3432L, 3436L, 3371L, 3409L, 3413L, 3348L, 3409L,
    3413L, 3348L, 3345L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.1823227952019, 1.31963937776922,
    1.47393911858572, 1.59519383809225, 1.75276938726581, 1.92416022709516,
    2.14065409346163, 2.35656626065807, 2.77524416003578
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3342L, 3342L, 3295L, 3342L, 3295L,
    3323L, 3342L, 3295L, 3323L, 3248L, 3254L, 3246L, 3254L, 3246L,
    3327L, 3319L, 3254L, 3246L, 3327L, 3319L, 3368L, 3360L, 3340L,
    3258L, 3350L, 3340L, 3258L, 3350L, 3309L, 3227L, 3319L, 3328L,
    3230L, 3266L, 3244L
  ), n0 = c(
    3236L, 3280L, 3372L, 3324L, 3360L,
    3338L, 3483L, 3401L, 3415L, 3523L, 3372L, 3290L, 3360L, 3262L,
    3338L, 3240L, 3401L, 3416L, 3415L, 3430L, 3523L, 3538L, 3338L,
    3240L, 3276L, 3415L, 3430L, 3348L, 3523L, 3538L, 3456L, 3523L,
    3538L, 3456L, 3470L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.20492732773946, 1.32740269840682,
    1.46796777659833, 1.58086898802659, 1.73005677317219, 1.91478127132734,
    2.11892275355996, 2.36994267443253, 2.83310527327148
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3324L, 3324L, 3299L, 3324L, 3299L,
    3288L, 3324L, 3299L, 3288L, 3316L, 3450L, 3392L, 3450L, 3392L,
    3460L, 3402L, 3450L, 3392L, 3460L, 3402L, 3461L, 3403L, 3222L,
    3245L, 3227L, 3222L, 3245L, 3227L, 3255L, 3278L, 3260L, 3278L,
    3244L, 3292L, 3272L
  ), n0 = c(
    3418L, 3307L, 3289L, 3232L, 3280L,
    3260L, 3373L, 3346L, 3396L, 3420L, 3289L, 3312L, 3280L, 3246L,
    3260L, 3226L, 3346L, 3399L, 3396L, 3449L, 3420L, 3473L, 3260L,
    3226L, 3274L, 3396L, 3449L, 3422L, 3420L, 3473L, 3446L, 3420L,
    3473L, 3446L, 3496L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.22614669578403, 1.34102569711127,
    1.49169858522434, 1.61353388377323, 1.76171656607801, 1.95188344644932,
    2.14210699216535, 2.37510285724576, 2.7851962949703
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3237L, 3237L, 3272L, 3237L, 3272L,
    3370L, 3237L, 3272L, 3370L, 3353L, 3352L, 3308L, 3352L, 3308L,
    3388L, 3344L, 3352L, 3308L, 3388L, 3344L, 3412L, 3368L, 3303L,
    3332L, 3305L, 3303L, 3332L, 3305L, 3350L, 3379L, 3352L, 3179L,
    3268L, 3097L, 3192L
  ), n0 = c(
    3364L, 3271L, 3244L, 3325L, 3154L,
    3249L, 3543L, 3558L, 3503L, 3506L, 3244L, 3273L, 3154L, 3243L,
    3249L, 3338L, 3558L, 3539L, 3503L, 3484L, 3506L, 3487L, 3249L,
    3338L, 3167L, 3503L, 3484L, 3499L, 3506L, 3487L, 3502L, 3506L,
    3487L, 3502L, 3447L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  ))), list(coefs = structure(list(perc = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    1.21475297454862, 1.31468579955939,
    1.44575367800143, 1.58308568521235, 1.72585311767477, 1.90793773449532,
    2.12230353135703, 2.40258154818465, 2.81868290081375
  )), class = "data.frame", row.names = c(
    NA,
    -9L
  )), name_runs = structure(list(i = c(
    1, 2, 3, 4, 5, 6, 7,
    8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
  ), qteCohort = c(
    2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5
  ), preCohort = c(
    3, 4, 4,
    5, 5, 5, 6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6
  ), qteYear = c(
    2, 2, 3, 2, 3,
    4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5, 5
  ), preYear = c(
    1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3,
    1, 2, 3, 1, 2, 3, 4
  ), n1 = c(
    3324L, 3324L, 3261L, 3324L, 3261L,
    3313L, 3324L, 3261L, 3313L, 3336L, 3394L, 3338L, 3394L, 3338L,
    3392L, 3336L, 3394L, 3338L, 3392L, 3336L, 3474L, 3418L, 3285L,
    3327L, 3328L, 3285L, 3327L, 3328L, 3263L, 3305L, 3306L, 3337L,
    3335L, 3233L, 3333L
  ), n0 = c(
    3390L, 3312L, 3313L, 3336L, 3234L,
    3334L, 3489L, 3474L, 3481L, 3533L, 3313L, 3355L, 3234L, 3232L,
    3334L, 3332L, 3474L, 3435L, 3481L, 3442L, 3533L, 3494L, 3334L,
    3332L, 3230L, 3481L, 3442L, 3427L, 3533L, 3494L, 3479L, 3533L,
    3494L, 3479L, 3486L
  )), class = "data.frame", row.names = c(
    NA,
    -35L
  )))), class = "ecic", ecic = list(myProbs = c(
    0.1, 0.2, 0.3,
    0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), es = FALSE, periods_es = NA))

es1_known <-
  structure(list(list(coefs = list(structure(list(perc = c(
    0.1,
    0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), values = c(
    0.865448002563489,
    0.942178519639249, 0.979270941287332, 1.01425319589877, 1.08966100184306,
    1.14495411044133, 1.20147496852804, 1.249495760647, 1.3658262137128
  )), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      2.3847433952092,
      2.37187657625476, 2.41642305993792, 2.43492106278433, 2.47545764099731,
      2.51853027201251, 2.57554595566277, 2.64453836042537, 2.76088859987476
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      3.15153520907358,
      3.22576539752037, 3.26525461744654, 3.29753370146498, 3.36826784967731,
      3.44429954229601, 3.50128962426078, 3.55421738561253, 3.68232932095826
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      4.68156337391829,
      4.6596562423801, 4.70735836362679, 4.73592899710217, 4.79016225743993,
      4.85704741003153, 4.90261666562302, 4.90807793440994, 5.04701493801469
    )
  ), class = "data.frame", row.names = c(NA, -9L))), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3256L, 3256L,
      3335L, 3256L, 3335L, 3229L, 3256L, 3335L, 3229L, 3248L, 3533L,
      3567L, 3533L, 3567L, 3409L, 3443L, 3533L, 3567L, 3409L, 3443L,
      3405L, 3439L, 3237L, 3290L, 3260L, 3237L, 3290L, 3260L, 3327L,
      3380L, 3350L, 3252L, 3182L, 3246L, 3268L
    ), n0 = c(
      3454L,
      3287L, 3257L, 3192L, 3256L, 3278L, 3569L, 3600L, 3517L, 3557L,
      3257L, 3310L, 3256L, 3186L, 3278L, 3208L, 3600L, 3547L, 3517L,
      3464L, 3557L, 3504L, 3278L, 3208L, 3272L, 3517L, 3464L, 3495L,
      3557L, 3504L, 3535L, 3557L, 3504L, 3535L, 3452L
    ), diff = c(
      0,
      0, 1, 0, 1, 2, 0, 1, 2, 3, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
      2, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
    )
  ), row.names = c(
    NA,
    -35L
  ), class = "data.frame")), list(coefs = list(structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      0.912595355484534,
      0.971079611194766, 0.992047246696235, 1.0509123905015, 1.10582966606653,
      1.15480593315162, 1.19689305432596, 1.23918820504652, 1.35553548434629
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      2.37213740420442,
      2.38254261257374, 2.40339649344639, 2.43640846679598, 2.48142168318733,
      2.51015314631627, 2.55963244626479, 2.60488158026126, 2.69803044214262
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      3.10286569423147,
      3.12939866791464, 3.20327873830594, 3.27654527405252, 3.36228617973964,
      3.42199008355847, 3.47091040374992, 3.53711935185794, 3.66196360906251
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      4.49094803313735,
      4.5758765199035, 4.59407228633117, 4.63929593793898, 4.74439928556024,
      4.8072642562159, 4.91122619730177, 4.92459324329222, 5.04620219791541
    )
  ), class = "data.frame", row.names = c(NA, -9L))), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3167L, 3167L,
      3205L, 3167L, 3205L, 3261L, 3167L, 3205L, 3261L, 3289L, 3455L,
      3433L, 3455L, 3433L, 3491L, 3469L, 3455L, 3433L, 3491L, 3469L,
      3463L, 3441L, 3372L, 3302L, 3280L, 3372L, 3302L, 3280L, 3286L,
      3216L, 3194L, 3168L, 3198L, 3191L, 3197L
    ), n0 = c(
      3386L,
      3352L, 3330L, 3160L, 3153L, 3159L, 3484L, 3583L, 3533L, 3553L,
      3330L, 3260L, 3153L, 3183L, 3159L, 3189L, 3583L, 3543L, 3533L,
      3493L, 3553L, 3513L, 3159L, 3189L, 3182L, 3533L, 3493L, 3592L,
      3553L, 3513L, 3612L, 3553L, 3513L, 3612L, 3562L
    ), diff = c(
      0,
      0, 1, 0, 1, 2, 0, 1, 2, 3, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
      2, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
    )
  ), row.names = c(
    NA,
    -35L
  ), class = "data.frame")), list(coefs = list(structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      0.93864819313792,
      0.96502375558316, 1.00347805422387, 1.05919500557579, 1.10454831480542,
      1.13357119804896, 1.18060746995821, 1.22372338976779, 1.34641847717894
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      2.38540539118976,
      2.39165031812018, 2.42766206009637, 2.46691345990796, 2.48222276389431,
      2.52407304857569, 2.57374710104228, 2.62402602410689, 2.71062559944365
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      3.13711231009373,
      3.16705083352147, 3.24012851605335, 3.30066979413401, 3.36548509940758,
      3.4396349125055, 3.49342413697079, 3.55753503902009, 3.67513882833301
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), values = c(
      4.65247680082085,
      4.63603940901666, 4.65759233357687, 4.67691850053922, 4.74690382886969,
      4.80402271354412, 4.91312125405358, 4.92840785532268, 5.06683757371943
    )
  ), class = "data.frame", row.names = c(NA, -9L))), name_runs = structure(list(
    i = c(
      1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
      31, 32, 33, 34, 35
    ), qteCohort = c(
      2, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5
    ), preCohort = c(
      3, 4, 4, 5, 5, 5,
      6, 6, 6, 6, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6
    ), qteYear = c(
      2, 2, 3, 2, 3,
      4, 2, 3, 4, 5, 3, 3, 3, 3, 4, 4, 3, 3, 4, 4, 5, 5, 4, 4,
      4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5
    ), preYear = c(
      1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
      2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4
    ), n1 = c(
      3223L, 3223L,
      3201L, 3223L, 3201L, 3292L, 3223L, 3201L, 3292L, 3285L, 3469L,
      3424L, 3469L, 3424L, 3486L, 3441L, 3469L, 3424L, 3486L, 3441L,
      3487L, 3442L, 3410L, 3349L, 3275L, 3410L, 3349L, 3275L, 3319L,
      3258L, 3184L, 3245L, 3195L, 3160L, 3205L
    ), n0 = c(
      3423L,
      3347L, 3273L, 3244L, 3209L, 3254L, 3637L, 3550L, 3445L, 3546L,
      3273L, 3212L, 3209L, 3159L, 3254L, 3204L, 3550L, 3663L, 3445L,
      3558L, 3546L, 3659L, 3254L, 3204L, 3169L, 3445L, 3558L, 3471L,
      3546L, 3659L, 3572L, 3546L, 3659L, 3572L, 3467L
    ), diff = c(
      0,
      0, 1, 0, 1, 2, 0, 1, 2, 3, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
      2, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
    )
  ), row.names = c(
    NA,
    -35L
  ), class = "data.frame"))), class = "ecic", ecic = list(myProbs = c(
    0.1,
    0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  ), es = TRUE, periods_es = 3))
summary1_known <- structure(list(perc = c(
  0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8,
  0.9
), coefs = c(
  1.20652792828688, 1.32026946246403, 1.45963570967079,
  1.59069481166298, 1.74650314077746, 1.92208039132979, 2.12770961519026,
  2.37146765883249, 2.78821611280866
), se = c(
  NA_real_, NA_real_,
  NA_real_, NA_real_, NA_real_, NA_real_, NA_real_, NA_real_, NA_real_
)), class = c("ecic_table", "data.frame"), row.names = c(
  NA,
  -9L
), ecic_table = list(es = FALSE, periods_es = NA, myProbs = c(
  0.1,
  0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
)))

summary2_known <-
  structure(list(structure(list(perc = c(
    0.1, 0.2, 0.3, 0.4, 0.5,
    0.6, 0.7, 0.8, 0.9
  ), es = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), coefs = c(
    0.905563850395315, 0.959427295472392, 0.991598747402479,
    1.04145353065869, 1.10001299423834, 1.14444374721397, 1.1929918309374,
    1.2374691184871, 1.35592672507934
  ), se = c(
    0.0371032144550582,
    0.0152416714176516, 0.0121097870705044, 0.0239174431410618, 0.0089879516675098,
    0.010626563258544, 0.010967122780657, 0.0129719011379584, 0.00970978173417693
  )), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), es = c(
      1L,
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L
    ), coefs = c(
      2.38076206353446,
      2.38202316898289, 2.41582720449356, 2.44608099649609, 2.47970069602632,
      2.51758548896815, 2.56964183432328, 2.62448198826451, 2.72318154715367
    ), se = c(
      0.0074765046036894, 0.0098970997303856, 0.0121437520558553,
      0.0180567644257941, 0.0036963589597282, 0.00700787992038788,
      0.00871492148361322, 0.0198323216172744, 0.0332569671729449
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), es = c(
      2L,
      2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L
    ), coefs = c(
      3.13050440446626,
      3.17407163298549, 3.23622062393528, 3.29158292321717, 3.36534637627484,
      3.43530817945333, 3.48854138832716, 3.54962392549685, 3.67314391945126
    ), se = c(
      0.0249985745859188, 0.0485654750060311, 0.0311722009877002,
      0.0131170476330048, 0.00299324688114135, 0.0117672618509565,
      0.0157672186973337, 0.0109555911502502, 0.0103283736057534
    )
  ), class = "data.frame", row.names = c(NA, -9L)), structure(list(
    perc = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9), es = c(
      3L,
      3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L
    ), coefs = c(
      4.60832940262549,
      4.62385739043342, 4.65300766117828, 4.68404781186012, 4.76048845728995,
      4.82277812659718, 4.90898803899279, 4.92035967767495, 5.05335156988317
    ), se = c(
      0.102690294628182, 0.0431979357971626, 0.056782023942521,
      0.0487094173722279, 0.0257287581473103, 0.0297222936539341,
      0.00559853632531547, 0.0108059580536119, 0.011686289454775
    )
  ), class = "data.frame", row.names = c(NA, -9L))), class = c(
    "ecic_table",
    "list"
  ), ecic_table = list(es = TRUE, periods_es = 3, myProbs = c(
    0.1,
    0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9
  )))


# tests ----
# average
# results from ecic1 |> dput()
ecic1 <- ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, 
              dat = dat, progress_bar = "void", nReps = 1, boot = "no") # without boot
ecic1a <- ecic(yvar = "lemp", gvar = "first.treat", tvar = "year", ivar = "countyreal", boot = "normal",
               dat = dat, progress_bar = "void", nReps = 5) # with boot

expect_error(ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, progress_bar = "void")) # error (no dat)
expect_error(ecic(yvar = lemp, gvar = first.tat,   tvar = year, ivar = countyreal, dat = dat, progress_bar = "void")) # error (gvar wrong)
expect_error(ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, progress_bar = "void", nReps = 0)) # error (nreps != boot)
expect_error(ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, progress_bar = "void", boot = "blaa")) # error (boot wrong)

ecic7 <- ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, progress_bar = "void", boot = "weighted", nReps = 10)
ecic8 <- ecic(yvar = lemp, gvar = first.treat, tvar = year, ivar = countyreal, dat = dat, progress_bar = "void", boot = "normal", nReps = 10)

expect_equal(ecic1, ecic1_known)
expect_equal(ecic1a, ecic1a_known)
expect_equal(ecic7, ecic7_known)
expect_equal(ecic8, ecic8_known)

# ES
es1 <- ecic(
  yvar = "lemp", gvar = "first.treat", tvar = "year", ivar = "countyreal", dat = dat,
  boot = "weighted", nReps = 3, es = T, progress_bar = "void"
)

expect_equal(es1, es1_known)

# summary
sum1 <- summary(ecic1)
sum2 <- summary(es1)

expect_equal(sum1, summary1_known)
expect_equal(sum2, summary2_known)

# plot
expect_error(plot_ecic(sum2, es_type = "nos")) # error
expect_error(plot(es2))
