\name{TransformToDisplacementFieldFilter}
\alias{TransformToDisplacementFieldFilter}
\title{TransformToDisplacementFieldFilter}
\Rdversion{1.1}
\docType{class}
\description{
Generate a displacement field from a coordinate transform.
TransformToDisplacementFieldFilter}
\details{
Output information (spacing, size and direction) for the output image
should be set. This information has the normal defaults of unit
spacing, zero origin and identity direction. Optionally, the output
information can be obtained from a reference image. If the reference
image is provided and UseReferenceImage is On, then the spacing,
origin and direction of the reference image will be used.
Since this filter produces an image which is a different size than its
input, it needs to override several of the methods defined in ProcessObject in order to properly manage the pipeline execution model. In
particular, this filter overrides ProcessObject::GenerateOutputInformation() .
This filter is implemented as a multithreaded filter. It provides a
ThreadedGenerateData() method for its implementation.
Marius Staring, Leiden University Medical Center, The Netherlands.
 This class was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/240
See:
TransformToDisplacementFieldFilter for the procedural interface
itk::TransformToDisplacementFieldFilter for the Doxygen on the original ITK class.
TransformToDisplacementFieldFilter}
%C++ includes: sitkTransformToDisplacementFieldFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Transform &transform):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< double > GetOutputDirection() const:}{
Set the output direction cosine matrix.
}
\item{std::vector< double > GetOutputOrigin() const:}{
Get the output image origin.
}
\item{PixelIDValueEnum GetOutputPixelType() const:}{
Get the ouput pixel type.
}
\item{std::vector< double > GetOutputSpacing() const:}{
Get the output image spacing.
}
\item{std::vector< unsigned int > GetSize() const:}{
Set/Get the size of the output image.
}
\item{Self SetOutputDirection(std::vector< double > OutputDirection):}{
Set the output direction cosine matrix.
}
\item{Self SetOutputOrigin(std::vector< double > OutputOrigin):}{
Set the output image origin.
}
\item{Self SetOutputPixelType(PixelIDValueEnum OutputPixelType):}{
Set the output pixel type, only sitkVectorFloat32 and
sitkVectorFloat64 are supported.
}
\item{Self SetOutputSpacing(std::vector< double > OutputSpacing):}{
Set the output image spacing.
}
\item{void SetReferenceImage(const Image &refImage):}{
This methods sets the size, origin, spacing and direction to that of
the provided image
}
\item{Self SetSize(std::vector< unsigned int > Size):}{
Set/Get the size of the output image.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ TransformToDisplacementFieldFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~TransformToDisplacementFieldFilter():}{
Destructor
}
}
}
