from collections.abc import Callable, Sequence
from contextlib import AbstractContextManager
from types import TracebackType
from typing import Any, TypeVar

from django.test import LiveServerTestCase
from typing_extensions import Self

_F = TypeVar("_F", bound=Callable[..., Any])

class SeleniumTestCaseBase:
    browsers: Any
    browser: Any
    @classmethod
    def import_webdriver(cls, browser: Any) -> type[Any]: ...  # Type[WebDriver]
    def create_webdriver(self) -> Any: ...  # WebDriver

class ChangeWindowSize:
    def __init__(self, width: int, height: int, selenium: Any) -> None: ...
    def __enter__(self) -> Self: ...
    def __exit__(
        self,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
    ) -> None: ...

class SeleniumTestCase(LiveServerTestCase):
    implicit_wait: int
    screenshots: bool = False
    selenium: Any
    def desktop_size(self) -> AbstractContextManager[None]: ...
    def small_screen_size(self) -> AbstractContextManager[None]: ...
    def mobile_size(self) -> AbstractContextManager[None]: ...
    def rtl(self) -> AbstractContextManager[None]: ...
    def dark(self) -> AbstractContextManager[None]: ...
    def set_emulated_media(self, *, media: str | None = None, features: list[dict[str, str]] | None = None) -> None: ...
    def high_contrast(self) -> AbstractContextManager[None]: ...
    def take_screenshot(self, name: str) -> None: ...
    def disable_implicit_wait(self) -> AbstractContextManager[None]: ...

def screenshot_cases(method_names: str | Sequence[str]) -> Callable[[_F], _F]: ...
