/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleBackendServiceDisposable;
import com.jetbrains.python.console.PythonConsoleClientUtil;
import com.jetbrains.python.console.protocol.PythonConsoleBackendService;
import com.jetbrains.python.console.protocol.PythonConsoleFrontendService;
import com.jetbrains.python.console.transport.server.ServerClosedException;
import com.jetbrains.python.console.transport.server.TNettyServer;
import com.jetbrains.python.console.transport.server.TNettyServerTransport;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TTransport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0017J\b\u0010 \u001a\u00020\u000fH\u0014J\f\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0014J\b\u0010#\u001a\u00020\u0019H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/python/console/PydevConsoleCommunicationServer;", "Lcom/jetbrains/python/console/PydevConsoleCommunication;", "project", "Lcom/intellij/openapi/project/Project;", "host", "", "port", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;I)V", "serverTransport", "Lcom/jetbrains/python/console/transport/server/TNettyServerTransport;", "server", "Lcom/jetbrains/python/console/transport/server/TNettyServer;", "client", "Lcom/jetbrains/python/console/PythonConsoleBackendServiceDisposable;", "stateLock", "Ljava/util/concurrent/locks/Lock;", "stateChanged", "Ljava/util/concurrent/locks/Condition;", "initialPythonConsoleClient", "Lcom/jetbrains/python/console/protocol/PythonConsoleBackendService$Iface;", "_pythonConsoleProcess", "Ljava/lang/Process;", "isFailedOnBound", "", "isServerBound", "isClosed", "serve", "", "setPythonConsoleProcess", "pythonConsoleProcess", "getPythonConsoleBackendClient", "closeCommunication", "Ljava/util/concurrent/Future;", "isCommunicationClosed", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPydevConsoleCommunicationServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PydevConsoleCommunicationServer.kt\ncom/jetbrains/python/console/PydevConsoleCommunicationServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public final class PydevConsoleCommunicationServer
extends PydevConsoleCommunication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TNettyServerTransport serverTransport;
    @NotNull
    private final TNettyServer server;
    @Nullable
    private PythonConsoleBackendServiceDisposable client;
    @NotNull
    private final Lock stateLock;
    @NotNull
    private final Condition stateChanged;
    @Nullable
    private PythonConsoleBackendService.Iface initialPythonConsoleClient;
    @Nullable
    private Process _pythonConsoleProcess;
    private boolean isFailedOnBound;
    private boolean isServerBound;
    private boolean isClosed;
    @NotNull
    private static final Logger LOG;

    public PydevConsoleCommunicationServer(@NotNull Project project, @NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(project);
        this.stateLock = new ReentrantLock();
        Condition condition = this.stateLock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        this.stateChanged = condition;
        PythonConsoleFrontendService.Iface iface = this.createPythonConsoleFrontendHandler();
        Intrinsics.checkNotNullExpressionValue((Object)iface, (String)"createPythonConsoleFrontendHandler(...)");
        PythonConsoleFrontendService.Iface serverHandler = iface;
        PythonConsoleFrontendService.Processor<PythonConsoleFrontendService.Iface> serverProcessor = new PythonConsoleFrontendService.Processor<PythonConsoleFrontendService.Iface>(serverHandler);
        this.serverTransport = new TNettyServerTransport(host, port);
        this.server = new TNettyServer(this.serverTransport, (TProcessor)serverProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serve() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> PydevConsoleCommunicationServer.serve$lambda$0(this));
        ApplicationManager.getApplication().executeOnPooledThread(() -> PydevConsoleCommunicationServer.serve$lambda$1(this));
        Lock lock2 = this.stateLock;
        lock2.lock();
        try {
            boolean bl = false;
            try {
                this.serverTransport.waitForBind();
                this.isServerBound = true;
                this.isFailedOnBound = !this.isServerBound;
            }
            catch (Throwable throwable) {
                this.isFailedOnBound = !this.isServerBound;
                this.stateChanged.signalAll();
                throw throwable;
            }
            this.stateChanged.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPythonConsoleProcess(@NotNull Process pythonConsoleProcess) {
        Intrinsics.checkNotNullParameter((Object)pythonConsoleProcess, (String)"pythonConsoleProcess");
        Lock lock2 = this.stateLock;
        lock2.lock();
        try {
            boolean bl = false;
            if (this.isClosed) {
                throw new PydevConsoleCommunication.CommunicationClosedException();
            }
            if (!this.isServerBound) {
                LOG.warn("Python Console process is set before IDE server is bound, the process may not be able to connect to the server");
            }
            this._pythonConsoleProcess = pythonConsoleProcess;
            this.stateChanged.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected PythonConsoleBackendServiceDisposable getPythonConsoleBackendClient() {
        Lock lock2 = this.stateLock;
        lock2.lock();
        try {
            boolean bl = false;
            while (!this.isClosed && !this.isFailedOnBound) {
                PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable = this.client;
                if (pythonConsoleBackendServiceDisposable != null) {
                    PythonConsoleBackendServiceDisposable it = pythonConsoleBackendServiceDisposable;
                    boolean bl2 = false;
                    PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable2 = it;
                    return pythonConsoleBackendServiceDisposable2;
                }
                PythonConsoleBackendService.Iface initialPythonConsoleClient = this.initialPythonConsoleClient;
                Process pythonConsoleProcess = this._pythonConsoleProcess;
                if (initialPythonConsoleClient != null && pythonConsoleProcess != null) {
                    void var3_6;
                    PythonConsoleBackendServiceDisposable newClient;
                    ClassLoader classLoader = PydevConsoleCommunication.class.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                    this.client = newClient = PythonConsoleClientUtil.synchronizedPythonConsoleClient(classLoader, initialPythonConsoleClient, pythonConsoleProcess);
                    void var7_10 = var3_6;
                    return var7_10;
                }
                this.stateChanged.await();
            }
            throw new PydevConsoleCommunication.CommunicationClosedException();
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Future<?> closeCommunication() {
        block16: {
            Object object;
            ProgressIndicator progressIndicator = ProgressIndicatorProvider.getInstance().getProgressIndicator();
            Lock lock2 = this.stateLock;
            lock2.lock();
            try {
                boolean bl = false;
                try {
                    this.isClosed = true;
                }
                finally {
                    this.stateChanged.signalAll();
                }
                object = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
            try {
                PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable = this.client;
                if (pythonConsoleBackendServiceDisposable != null) {
                    Object $this$closeCommunication_u24lambda_u241 = object = pythonConsoleBackendServiceDisposable;
                    boolean bl = false;
                    ProgressIndicator progressIndicator2 = progressIndicator;
                    if (progressIndicator2 != null) {
                        progressIndicator2.setText2(PyBundle.message("debugger.sending.close.message", new Object[0]));
                    }
                    $this$closeCommunication_u24lambda_u241.close();
                    $this$closeCommunication_u24lambda_u241.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Process process2 = this._pythonConsoleProcess;
            if (process2 == null) break block16;
            Process it = process2;
            boolean bl = false;
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2(PyBundle.message("debugger.waiting.to.finish", new Object[0]));
            }
            try {
                do {
                    ProgressIndicator progressIndicator4 = progressIndicator;
                    if (progressIndicator4 == null) continue;
                    progressIndicator4.checkCanceled();
                } while (!it.waitFor(500L, TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommunicationClosed() {
        boolean bl;
        Lock lock2 = this.stateLock;
        lock2.lock();
        try {
            boolean bl2 = false;
            bl = this.isClosed;
        }
        finally {
            lock2.unlock();
        }
        return bl;
    }

    private static final void serve$lambda$0(PydevConsoleCommunicationServer this$0) {
        this$0.server.serve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void serve$lambda$1(PydevConsoleCommunicationServer this$0) {
        TTransport clientTransport = null;
        try {
            clientTransport = this$0.serverTransport.getReverseTransport();
        }
        catch (ServerClosedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        TBinaryProtocol clientProtocol = new TBinaryProtocol(clientTransport);
        PythonConsoleBackendService.Client client = new PythonConsoleBackendService.Client(clientProtocol);
        Lock lock2 = this$0.stateLock;
        lock2.lock();
        try {
            boolean bl = false;
            if (this$0.isClosed) {
                this$0.server.stop();
                throw new ProcessCanceledException();
            }
            this$0.initialPythonConsoleClient = client;
            this$0.stateChanged.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
        PyDebugValueExecutionService executionService = PyDebugValueExecutionService.getInstance((Project)this$0.myProject);
        executionService.sessionStarted((PyFrameAccessor)this$0);
        this$0.addFrameListener(new PyFrameListener(executionService, this$0){
            final /* synthetic */ PyDebugValueExecutionService $executionService;
            final /* synthetic */ PydevConsoleCommunicationServer this$0;
            {
                this.$executionService = $executionService;
                this.this$0 = $receiver;
            }

            public void frameChanged() {
                this.$executionService.cancelSubmittedTasks((PyFrameAccessor)this.this$0);
            }

            public void sessionStopped(PyFrameAccessor communication) {
                this.$executionService.cancelSubmittedTasks((PyFrameAccessor)this.this$0);
            }
        });
    }

    static {
        Logger logger = Logger.getInstance(PydevConsoleCommunicationServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/console/PydevConsoleCommunicationServer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

