/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.fixtures;

import com.intellij.driver.model.TreePathToRowListWithCheckboxState;
import com.intellij.driver.model.TreePathToRowListWithCheckboxStateList;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.EdtUtilKt;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.TextCellRendererReader;
import com.jetbrains.performancePlugin.remotedriver.fixtures.JTreeTextFixture;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.assertj.swing.core.Robot;
import org.assertj.swing.driver.BasicJTreeCellReader;
import org.assertj.swing.driver.CellRendererReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\rH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/fixtures/JCheckboxTreeFixture;", "Lcom/jetbrains/performancePlugin/remotedriver/fixtures/JTreeTextFixture;", "robot", "Lorg/assertj/swing/core/Robot;", "component", "Ljavax/swing/JTree;", "<init>", "(Lorg/assertj/swing/core/Robot;Ljavax/swing/JTree;)V", "textCellReader", "Lorg/assertj/swing/driver/BasicJTreeCellReader;", "getCheckBoxForNode", "Ljavax/swing/JCheckBox;", "fileTreePath", "Ljavax/swing/tree/TreePath;", "toStringList", "", "", "collectCheckboxes", "Lcom/intellij/driver/model/TreePathToRowListWithCheckboxStateList;", "switchCheckBoxByPath", "", "path", "state", "", "clickOnCheckbox", "checkbox", "checkboxLocation", "Ljava/awt/Rectangle;", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nJCheckboxTreeFixture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JCheckboxTreeFixture.kt\ncom/jetbrains/performancePlugin/remotedriver/fixtures/JCheckboxTreeFixture\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n3260#2,11:90\n11561#2:101\n11896#2,3:102\n1#3:105\n*S KotlinDebug\n*F\n+ 1 JCheckboxTreeFixture.kt\ncom/jetbrains/performancePlugin/remotedriver/fixtures/JCheckboxTreeFixture\n*L\n29#1:90,11\n35#1:101\n35#1:102,3\n*E\n"})
public final class JCheckboxTreeFixture
extends JTreeTextFixture {
    @NotNull
    private final Robot robot;
    @NotNull
    private final JTree component;
    @NotNull
    private final BasicJTreeCellReader textCellReader;

    public JCheckboxTreeFixture(@NotNull Robot robot, @NotNull JTree component) {
        Intrinsics.checkNotNullParameter((Object)robot, (String)"robot");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(robot, component);
        this.robot = robot;
        this.component = component;
        this.textCellReader = new BasicJTreeCellReader((CellRendererReader)new TextCellRendererReader(null, 1, null));
    }

    @NotNull
    public final JCheckBox getCheckBoxForNode(@NotNull TreePath fileTreePath) {
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter((Object)fileTreePath, (String)"fileTreePath");
            Object object2 = fileTreePath.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object2;
            Component renderer = (Component)EdtUtilKt.computeOnEdt(() -> JCheckboxTreeFixture.getCheckBoxForNode$lambda$0(this, fileTreePath, node));
            JPanel jPanel = renderer instanceof JPanel ? (JPanel)renderer : null;
            if (jPanel == null) {
                throw new IllegalStateException("Only JPanel is currently supported".toString());
            }
            JPanel jpanel = jPanel;
            Component[] componentArray = jpanel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] $this$singleOrNull$iv = componentArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                if (!(it instanceof JCheckBox)) continue;
                if (found$iv) {
                    object = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : single$iv;
        }
        Object object3 = object;
        JCheckBox jCheckBox = object3 instanceof JCheckBox ? (JCheckBox)object3 : null;
        if (jCheckBox == null) {
            throw new IllegalStateException("Only JCheckBox is currently supported".toString());
        }
        JCheckBox checkbox = jCheckBox;
        return checkbox;
    }

    private final List<String> toStringList(TreePath $this$toStringList) {
        return (List)EdtUtilKt.computeOnEdt(() -> JCheckboxTreeFixture.toStringList$lambda$0($this$toStringList, this));
    }

    @NotNull
    public final TreePathToRowListWithCheckboxStateList collectCheckboxes() {
        TreePathToRowListWithCheckboxStateList result = new TreePathToRowListWithCheckboxStateList();
        EdtUtilKt.computeOnEdt(() -> JCheckboxTreeFixture.collectCheckboxes$lambda$0(this, result));
        return result;
    }

    public final void switchCheckBoxByPath(@NotNull List<String> path, boolean state) {
        DefaultMutableTreeNode node;
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Object object = this.component.getModel().getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        DefaultMutableTreeNode defaultMutableTreeNode = node = TreeUtil.findNode((DefaultMutableTreeNode)root, arg_0 -> JCheckboxTreeFixture.switchCheckBoxByPath$lambda$1(arg_0 -> JCheckboxTreeFixture.switchCheckBoxByPath$lambda$0(this, path, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)defaultMutableTreeNode);
        TreePath fileTreePath = new TreePath(defaultMutableTreeNode.getPath());
        JCheckBox checkbox = this.getCheckBoxForNode(fileTreePath);
        if (this.getCheckBoxForNode(fileTreePath).isSelected() == state) {
            return;
        }
        Rectangle checkboxLocation = (Rectangle)EdtUtilKt.computeOnEdt(() -> JCheckboxTreeFixture.switchCheckBoxByPath$lambda$2(this, fileTreePath));
        this.clickOnCheckbox(checkbox, checkboxLocation);
    }

    private final void clickOnCheckbox(JCheckBox checkbox, Rectangle checkboxLocation) {
        Rectangle checkBoxBounds = checkbox.getBounds();
        int clickX = checkboxLocation.x + checkBoxBounds.width / 2;
        int clickY = checkboxLocation.y + checkBoxBounds.height / 2;
        this.robot.click((Component)this.component, new Point(clickX, clickY));
    }

    private static final Component getCheckBoxForNode$lambda$0(JCheckboxTreeFixture this$0, TreePath $fileTreePath, DefaultMutableTreeNode $node) {
        TreeCellRenderer treeCellRenderer = this$0.component.getCellRenderer();
        JTree jTree = this$0.component;
        Object object = $fileTreePath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        return treeCellRenderer.getTreeCellRendererComponent(jTree, (DefaultMutableTreeNode)object, this$0.component.isPathSelected($fileTreePath), this$0.component.isExpanded($fileTreePath), this$0.component.getModel().isLeaf($node), this$0.component.getRowForPath($fileTreePath), this$0.component.isPathEditable($fileTreePath));
    }

    /*
     * WARNING - void declaration
     */
    private static final List toStringList$lambda$0(TreePath $this_toStringList, JCheckboxTreeFixture this$0) {
        void $this$mapTo$iv$iv;
        Object[] objectArray = $this_toStringList.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getPath(...)");
        Object[] $this$map$iv = objectArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this$0.textCellReader.valueAt(this$0.component, (Object)it);
            if (string == null) {
                string = "";
            }
            collection.add(string);
        }
        List nodes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (!this$0.component.isRootVisible()) {
            nodes.remove(0);
        }
        return nodes;
    }

    private static final Unit collectCheckboxes$lambda$0(JCheckboxTreeFixture this$0, TreePathToRowListWithCheckboxStateList $result) {
        TreeUtil.visitVisibleRows((JTree)this$0.component, arg_0 -> JCheckboxTreeFixture.collectCheckboxes$lambda$0$1(arg_0 -> JCheckboxTreeFixture.collectCheckboxes$lambda$0$0(this$0, arg_0), arg_0), arg_0 -> JCheckboxTreeFixture.collectCheckboxes$lambda$0$3(arg_0 -> JCheckboxTreeFixture.collectCheckboxes$lambda$0$2($result, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final TreePathToRowListWithCheckboxState collectCheckboxes$lambda$0$0(JCheckboxTreeFixture this$0, TreePath path) {
        Object object = this$0.component.getModel().getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        Intrinsics.checkNotNull((Object)path);
        return new TreePathToRowListWithCheckboxState(this$0.toStringList(path), this$0.component.getRowForPath(path), this$0.getCheckBoxForNode(path).isSelected());
    }

    private static final TreePathToRowListWithCheckboxState collectCheckboxes$lambda$0$1(Function1 $tmp0, Object p0) {
        return (TreePathToRowListWithCheckboxState)$tmp0.invoke(p0);
    }

    private static final Unit collectCheckboxes$lambda$0$2(TreePathToRowListWithCheckboxStateList $result, TreePathToRowListWithCheckboxState it) {
        $result.add(it);
        return Unit.INSTANCE;
    }

    private static final void collectCheckboxes$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean switchCheckBoxByPath$lambda$0(JCheckboxTreeFixture this$0, List $path, DefaultMutableTreeNode node) {
        return Intrinsics.areEqual(this$0.toStringList(new TreePath(node.getPath())), (Object)$path);
    }

    private static final boolean switchCheckBoxByPath$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Rectangle switchCheckBoxByPath$lambda$2(JCheckboxTreeFixture this$0, TreePath $fileTreePath) {
        Rectangle rectangle = this$0.component.getPathBounds($fileTreePath);
        if (rectangle == null) {
            boolean bl = false;
            String string = "Have not found bounds";
            throw new IllegalStateException(string.toString());
        }
        return rectangle;
    }
}

