/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec.KNN9120DerivedSourceReaders;
import org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec.ParentChildHelper;

public class NestedPerFieldParentToDocIdIterator {
    private final FieldInfo childFieldInfo;
    private final SegmentReadState segmentReadState;
    private final KNN9120DerivedSourceReaders derivedSourceReaders;
    private final int parentDocId;
    private final int previousParentDocId;
    private final List<Integer> children;
    private int currentChild;

    public NestedPerFieldParentToDocIdIterator(FieldInfo childFieldInfo, SegmentReadState segmentReadState, KNN9120DerivedSourceReaders derivedSourceReaders, int parentDocId) throws IOException {
        this.childFieldInfo = childFieldInfo;
        this.segmentReadState = segmentReadState;
        this.derivedSourceReaders = derivedSourceReaders;
        this.parentDocId = parentDocId;
        this.previousParentDocId = this.previousParent();
        this.children = this.getChildren();
        this.currentChild = -1;
    }

    public int firstChild() {
        if (this.parentDocId - this.previousParentDocId == 1) {
            return Integer.MAX_VALUE;
        }
        return this.previousParentDocId + 1;
    }

    public int nextChild() {
        ++this.currentChild;
        if (this.currentChild >= this.children.size()) {
            return Integer.MAX_VALUE;
        }
        return this.children.get(this.currentChild);
    }

    public int childId() {
        return this.children.get(this.currentChild);
    }

    public int numChildren() {
        return this.children.size();
    }

    private int previousParent() throws IOException {
        FieldInfo seqTermsFieldInfo = this.segmentReadState.fieldInfos.fieldInfo("_primary_term");
        NumericDocValues numericDocValues = this.derivedSourceReaders.getDocValuesProducer().getNumeric(seqTermsFieldInfo);
        int previousParentDocId = -1;
        while (numericDocValues.nextDoc() != Integer.MAX_VALUE && numericDocValues.docID() < this.parentDocId) {
            previousParentDocId = numericDocValues.docID();
        }
        return previousParentDocId;
    }

    private List<Integer> getChildren() throws IOException {
        if (this.parentDocId - this.previousParentDocId <= 1) {
            return Collections.emptyList();
        }
        String childField = this.childFieldInfo.name;
        String parentField = ParentChildHelper.getParentField(childField);
        Terms terms = this.derivedSourceReaders.getFieldsProducer().terms("_nested_path");
        if (terms == null) {
            return Collections.emptyList();
        }
        TermsEnum nestedFieldsTerms = terms.iterator();
        BytesRef childPathRef = new BytesRef((CharSequence)parentField);
        PostingsEnum postingsEnum = null;
        while (nestedFieldsTerms.next() != null) {
            BytesRef currentTerm = nestedFieldsTerms.term();
            if (!currentTerm.bytesEquals(childPathRef)) continue;
            postingsEnum = nestedFieldsTerms.postings(null);
            break;
        }
        if (postingsEnum == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> children = new ArrayList<Integer>();
        postingsEnum.advance(this.previousParentDocId + 1);
        while (postingsEnum.docID() != Integer.MAX_VALUE && postingsEnum.docID() < this.parentDocId) {
            if (postingsEnum.freq() > 0) {
                children.add(postingsEnum.docID());
            }
            postingsEnum.nextDoc();
        }
        return children;
    }
}

