/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.common.settings.Settings;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.KnnCircuitBreakerException;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.KNNVectorAsCollectionOfFloatsSerializer;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.util.IndexHyperParametersUtil;

public class KNNVectorFieldMapperUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNVectorFieldMapperUtil.class);

    public static FieldType buildDocValuesFieldType(KNNEngine knnEngine) {
        FieldType field = new FieldType();
        field.putAttribute("engine", knnEngine.getName());
        field.setDocValuesType(DocValuesType.BINARY);
        field.freeze();
        return field;
    }

    public static StoredField createStoredFieldForByteVector(String name, byte[] vector) {
        return new StoredField(name, vector);
    }

    public static StoredField createStoredFieldForFloatVector(String name, float[] vector) {
        return new StoredField(name, KNNVectorAsCollectionOfFloatsSerializer.INSTANCE.floatToByteArray(vector));
    }

    public static Object deserializeStoredVector(BytesRef storedVector, VectorDataType vectorDataType) {
        if (VectorDataType.BYTE == vectorDataType || VectorDataType.BINARY == vectorDataType) {
            byte[] bytes = storedVector.bytes;
            int[] byteAsIntArray = new int[storedVector.length];
            Arrays.setAll(byteAsIntArray, i -> bytes[i + storedVector.offset]);
            return byteAsIntArray;
        }
        return vectorDataType.getVectorFromBytesRef(storedVector);
    }

    public static int getExpectedVectorLength(KNNVectorFieldType knnVectorFieldType) {
        int expectedDimensions = knnVectorFieldType.getKnnMappingConfig().getDimension();
        return VectorDataType.BINARY == knnVectorFieldType.getVectorDataType() ? expectedDimensions / 8 : expectedDimensions;
    }

    static void validateIfCircuitBreakerIsNotTriggered() {
        if (KNNSettings.isCircuitBreakerTriggered()) {
            throw new KnnCircuitBreakerException("Parsing the created knn vector fields prior to indexing has failed as the circuit breaker triggered.  This indicates that the cluster is low on memory resources and cannot index more documents at the moment. Check _plugins/_knn/stats for the circuit breaker status.");
        }
    }

    static boolean useLuceneKNNVectorsFormat(Version indexCreatedVersion) {
        return indexCreatedVersion.onOrAfter(Version.V_2_17_0);
    }

    static boolean useFullFieldNameValidation(Version indexCreatedVersion) {
        return indexCreatedVersion != null && indexCreatedVersion.onOrAfter(Version.V_2_17_0);
    }

    private static int getM() {
        return KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M;
    }

    private static int getEfConstruction(Version indexVersion) {
        return IndexHyperParametersUtil.getHNSWEFConstructionValue(indexVersion);
    }

    static KNNMethodContext createKNNMethodContextFromLegacy(Settings indexSettings, Version indexCreatedVersion, SpaceType resolvedSpaceType) {
        return new KNNMethodContext(KNNEngine.NMSLIB, resolvedSpaceType, new MethodComponentContext("hnsw", Map.of("m", KNNVectorFieldMapperUtil.getM(), "ef_construction", KNNVectorFieldMapperUtil.getEfConstruction(indexCreatedVersion))));
    }

    @Generated
    private KNNVectorFieldMapperUtil() {
    }
}

