function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiPopover } from '../../../popover';
import { formatTimeString } from '../pretty_duration';
import { OuiDatePopoverContent } from './date_popover_content';
// eslint-disable-line import/named

export var OuiDatePopoverButton = function OuiDatePopoverButton(props) {
  var position = props.position,
    isDisabled = props.isDisabled,
    isInvalid = props.isInvalid,
    needsUpdating = props.needsUpdating,
    value = props.value,
    buttonProps = props.buttonProps,
    roundUp = props.roundUp,
    onChange = props.onChange,
    locale = props.locale,
    dateFormat = props.dateFormat,
    utcOffset = props.utcOffset,
    timeFormat = props.timeFormat,
    isOpen = props.isOpen,
    onPopoverToggle = props.onPopoverToggle,
    onPopoverClose = props.onPopoverClose,
    compressed = props.compressed,
    rest = _objectWithoutProperties(props, ["position", "isDisabled", "isInvalid", "needsUpdating", "value", "buttonProps", "roundUp", "onChange", "locale", "dateFormat", "utcOffset", "timeFormat", "isOpen", "onPopoverToggle", "onPopoverClose", "compressed"]);
  var classes = classNames(['ouiDatePopoverButton', "ouiDatePopoverButton--".concat(position), {
    'ouiDatePopoverButton-isSelected': isOpen,
    'ouiDatePopoverButton-isInvalid': isInvalid,
    'ouiDatePopoverButton-needsUpdating': needsUpdating,
    'ouiDatePopoverButton-disabled': isDisabled,
    'ouiDatePopoverButton-compressed': compressed
  }]);
  var title = value;
  if (isInvalid) {
    title = "Invalid date: ".concat(title);
  } else if (needsUpdating) {
    title = "Update needed: ".concat(title);
  }
  var button = /*#__PURE__*/React.createElement("button", _extends({
    onClick: onPopoverToggle,
    className: classes,
    title: title,
    disabled: isDisabled,
    "data-test-subj": "superDatePicker".concat(position, "DatePopoverButton")
  }, buttonProps), formatTimeString(value, dateFormat, roundUp, locale));
  return /*#__PURE__*/React.createElement(OuiPopover, _extends({
    button: button,
    isOpen: isOpen,
    closePopover: onPopoverClose,
    anchorPosition: position === 'start' ? 'downLeft' : 'downRight',
    display: "block",
    panelPaddingSize: "none"
  }, rest), /*#__PURE__*/React.createElement(OuiDatePopoverContent, {
    value: value,
    roundUp: roundUp,
    onChange: onChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    position: position,
    utcOffset: utcOffset
  }));
};
OuiDatePopoverButton.propTypes = {
  className: PropTypes.string,
  buttonProps: PropTypes.any,
  dateFormat: PropTypes.string.isRequired,
  isDisabled: PropTypes.bool,
  isInvalid: PropTypes.bool,
  isOpen: PropTypes.bool.isRequired,
  needsUpdating: PropTypes.bool,
  locale: PropTypes.any,
  onChange: PropTypes.any.isRequired,
  onPopoverClose: PropTypes.func.isRequired,
  onPopoverToggle: PropTypes.func.isRequired,
  position: PropTypes.oneOf(["start", "end"]).isRequired,
  roundUp: PropTypes.bool,
  timeFormat: PropTypes.string.isRequired,
  value: PropTypes.string.isRequired,
  utcOffset: PropTypes.number,
  compressed: PropTypes.bool
};
OuiDatePopoverButton.displayName = 'OuiDatePopoverButton';

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */export { EuiDatePopoverButton } from '../../../../eui_components/date_picker/super_date_picker/date_popover/date_popover_button';