/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestCancellableNodeClient;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.rest.action.search.RestSearchAction;
import org.opensearch.search.asynchronous.action.SubmitAsynchronousSearchAction;
import org.opensearch.search.asynchronous.request.SubmitAsynchronousSearchRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestSubmitAsynchronousSearchAction
extends BaseRestHandler {
    public static final String TOTAL_HITS_AS_INT_PARAM = "rest_total_hits_as_int";
    public static final String TYPED_KEYS_PARAM = "typed_keys";
    private static final Set<String> RESPONSE_PARAMS;

    public String getName() {
        return "submit_asynchronous_search_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/{index}/_plugins/_asynchronous_search", RestRequest.Method.POST, "/{index}/_opendistro/_asynchronous_search"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_asynchronous_search", RestRequest.Method.POST, "/_opendistro/_asynchronous_search"));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        IntConsumer setSize = size -> searchRequest.source().size(size);
        request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, (XContentParser)parser, (NamedWriteableRegistry)client.getNamedWriteableRegistry(), (IntConsumer)setSize));
        SubmitAsynchronousSearchRequest submitAsynchronousSearchRequest = new SubmitAsynchronousSearchRequest(searchRequest);
        submitAsynchronousSearchRequest.waitForCompletionTimeout(request.paramAsTime("wait_for_completion_timeout", SubmitAsynchronousSearchRequest.DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT));
        submitAsynchronousSearchRequest.keepAlive(request.paramAsTime("keep_alive", SubmitAsynchronousSearchRequest.DEFAULT_KEEP_ALIVE));
        submitAsynchronousSearchRequest.keepOnCompletion(request.paramAsBoolean("keep_on_completion", SubmitAsynchronousSearchRequest.DEFAULT_KEEP_ON_COMPLETION));
        searchRequest.requestCache(request.paramAsBoolean("request_cache", SubmitAsynchronousSearchRequest.DEFAULT_REQUEST_CACHE));
        searchRequest.setBatchedReduceSize(request.paramAsInt("batched_reduce_size", 5));
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute((ActionType)SubmitAsynchronousSearchAction.INSTANCE, (ActionRequest)submitAsynchronousSearchRequest, (ActionListener)new RestStatusToXContentListener(channel));
        };
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    public boolean allowsUnsafeBuffers() {
        return true;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList(TYPED_KEYS_PARAM, TOTAL_HITS_AS_INT_PARAM));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

