/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.test;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;

public class FixedEntropySourceProvider
implements EntropySourceProvider {
    private final byte[] data;
    private final boolean isPredictionResistant;

    public FixedEntropySourceProvider(byte[] byArray, boolean bl) {
        this.data = byArray;
        this.isPredictionResistant = bl;
    }

    @Override
    public EntropySource get(final int n) {
        return new EntropySource(){
            boolean first = true;
            int index = 0;

            @Override
            public boolean isPredictionResistant() {
                return FixedEntropySourceProvider.this.isPredictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                byte[] byArray = new byte[(n + 7) / 8];
                System.arraycopy(FixedEntropySourceProvider.this.data, this.index, byArray, 0, byArray.length);
                if (this.first) {
                    int n3 = 0;
                    while (n3 != byArray.length) {
                        int n2 = n3++;
                        byArray[n2] = (byte)(byArray[n2] ^ 0xFF);
                    }
                    this.first = false;
                } else {
                    this.index += (n + 7) / 8;
                }
                return byArray;
            }

            @Override
            public int entropySize() {
                return n;
            }
        };
    }
}

