/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#pragma once

#include "common_types.h"
#include "fabric_dump_parser.h"

using MapPortKeyToAggNodeRecord = std::map<port_key_t, AggNodeRecord>;
using MapPortKeyToAggNodeInfoRecord = std::map<port_key_t, AggNodeInfoRecord>;

//---------------------------
// This struct is used for holding the information required during restart, in order to
// perform the seamless restart operation.
//---------------------------

struct RestartInfo
{
    MapPortKeyToAggNodeRecord m_agg_node_records_by_port_key_;
    MapPortKeyToAggNodeInfoRecord m_agg_node_info_records_by_port_key_;
    VecAggPathRecord m_agg_path_records_with_action_;
    MapFileNameToCRC m_file_crc_by_filename_;
    AMGeneralInfoRecord m_general_info_record_;

    int ReadAggNodeStateFromDump();
    int ValidateAggNodeStateFromDump(const VecAggNodeFabricPtr& agg_nodes);
    int CompareAggNodeInfoWithDump(const VecAggNodeFabricPtr& agg_nodes);
    int ValidateConfigFileCRC();
    void CleanRestartInfo();

    ////////////////////////////////////////////
    /// Fabric CSV Parser Call Backs Function
    ////////////////////////////////////////////

    int ParseAggNode(const AggNodeRecord& agg_node_record);
    int ParseAggNodeInfo(const AggNodeInfoRecord& agg_node_info_record);
    int ParseAggPath(const AggPathRecord& agg_path_record);
    int ParseConfigFileCRC(const FileCRCRecord& file_crc_record);
    int ParseAMGeneralInfo(const AMGeneralInfoRecord& am_general_info_record);
    AMGeneralInfoRecord& GetAMGeneralInfoRecord() { return m_general_info_record_; }
};
