/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.MarkingData;
import tim.prune.data.RangeStats;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.ParameterlessMethod;

public class SkiLiftsMethod
extends ParameterlessMethod {
    private static final long SECONDS_TO_LOOK_FORWARD = 120L;
    private static final int ALLOWED_METRES_DOWNHILL = 20;
    private static final int MINIMUM_ASCENT_FACTOR = 10;
    private static final double STRAIGHTNESS_FACTOR = 1.02;

    @Override
    public int compress(Track track, TrackDetails trackDetails, MarkingData markingData) {
        int n = track.getNumPoints();
        int n2 = markingData.getNumDeleted();
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            DataPoint dataPoint = track.getPoint(n4);
            int n5 = n4 + 1;
            DataPoint dataPoint2 = track.getPoint(n5);
            while (dataPoint2 != null && dataPoint2.hasAltitude() && dataPoint2.hasTimestamp() && !dataPoint2.isWaypoint() && dataPoint2.getTimestamp().getSecondsSince(dataPoint.getTimestamp()) < 120L) {
                dataPoint2 = track.getPoint(++n5);
            }
            if (this.looksLikeLiftRange(track, n4, n5)) {
                int n6 = n4;
                if (this.looksLikeLiftRange(track, n3, n4) || this.looksLikeLiftRange(track, n3, n5)) {
                    n6 = n3;
                }
                int n7 = n6;
                while (n7 <= n5) {
                    markingData.markPointForDeletion(n7, true, true);
                    ++n7;
                }
                n3 = n6;
                n4 = (n4 + n5) / 2;
            }
            ++n4;
        }
        return markingData.getNumDeleted() - n2;
    }

    @Override
    public CompressionMethodType getType() {
        return CompressionMethodType.SKI_LIFTS;
    }

    static boolean recogniseString(String string) {
        return SkiLiftsMethod.recogniseString(string, CompressionMethodType.SKI_LIFTS);
    }

    private boolean looksLikeLiftRange(Track track, int n, int n2) {
        int n3;
        Object object;
        if (n < 0) {
            return false;
        }
        int n4 = n;
        while (n4 <= n2) {
            object = track.getPoint(n4);
            if (object == null || ((DataPoint)object).isWaypoint() || !((DataPoint)object).hasAltitude() || !((DataPoint)object).hasTimestamp()) {
                return false;
            }
            ++n4;
        }
        RangeStats rangeStats = new RangeStats(track, n, n2, 0);
        object = UnitSetLibrary.UNITS_METRES;
        int n5 = rangeStats.getTotalAltitudeRange().getDescent((Unit)object);
        if (n5 < 20 && (n3 = rangeStats.getTotalAltitudeRange().getClimb((Unit)object)) > n5 * 10) {
            double d;
            double d2;
            DataPoint dataPoint = track.getPoint(n);
            DataPoint dataPoint2 = track.getPoint(n2);
            double d3 = rangeStats.getTotalDistance((Unit)object);
            return d3 / (d2 = Distance.convertRadiansToDistance(d = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2), (Unit)object)) < 1.02;
        }
        return false;
    }
}

