/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.EmptyBorder;

class GTabBorder
extends EmptyBorder {
    private static int LEFT_MARGIN = 7;
    private static int TOP_MARGIN = 4;
    private static int RIGHT_MARGIN = 2;
    private static int BOTTOM_MARGIN = 2;
    private int offset = 0;
    private boolean selected;

    GTabBorder(boolean selected) {
        super(TOP_MARGIN, LEFT_MARGIN, BOTTOM_MARGIN, RIGHT_MARGIN);
        this.selected = selected;
        if (!selected) {
            this.offset = 2;
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerHighlight = c.getBackground().brighter();
        Color outerHighlight = innerHighlight.brighter();
        Color innerShadow = c.getBackground().darker();
        Color outerShadow = innerShadow.darker();
        g.setColor(outerHighlight);
        g.drawLine(1, this.offset, w - 3, this.offset);
        g.setColor(innerHighlight);
        g.drawLine(2, this.offset + 1, w - 3, this.offset + 1);
        g.setColor(outerShadow);
        g.drawLine(0, this.offset + 1, 0, h - 1);
        g.setColor(innerHighlight);
        g.drawLine(1, this.offset + 1, 1, h - 2);
        g.setColor(innerShadow);
        g.drawLine(w - 2, this.offset + 1, w - 2, h);
        g.setColor(outerShadow);
        g.drawLine(w - 1, this.offset + 1, w - 1, h - 2);
        if (!this.selected) {
            g.setColor(outerHighlight);
            g.drawLine(0, h - 1, w - 1, h - 1);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

