/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class ExtraFrameAndProcedureInformationMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4114;
    private long procedureFrameTotalLength;
    private long procedureFramePaddingLength;
    private long paddingOffset;
    private long calleeSaveRegistersByteCount;
    private long exceptionHandlerOffset;
    private int exceptionHandlerSectionID;
    private long flags;
    private boolean usesAlloca;
    private boolean usesSetJmp;
    private boolean usesLongJmp;
    private boolean usesInlineAsm;
    private boolean hasExceptionHandlingStates;
    private boolean wasInlineSpec;
    private boolean wasStructuredExceptionHandling;
    private boolean isDeclspecNaked;
    private boolean hasGsBufferSecurityCheck;
    private boolean compiledWithAsyncExceptionHandling;
    private boolean couldNotDoStackOrderingWithGsBufferSecurityChecks;
    private boolean wasInlinedWithinAnotherFunction;
    private boolean isDeclspecStrictGsCheck;
    private boolean isDeclspecSafeBuffers;
    private RegisterName explicitlyEncodedLocalBasePointer;
    private RegisterName explicitlyEncodedParameterPointer;
    private boolean wasCompiledWithPgoPgu;
    private boolean hasvalidPogoCounts;
    private boolean optimizedForSpeed;
    private boolean containsCfgChecksButNoWriteChecks;
    private boolean containsCfwChecksAndOrInstrumentation;
    private int padding;

    public ExtraFrameAndProcedureInformationMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.procedureFrameTotalLength = reader.parseUnsignedIntVal();
        this.procedureFramePaddingLength = reader.parseUnsignedIntVal();
        this.paddingOffset = reader.parseVarSizedOffset(32);
        this.calleeSaveRegistersByteCount = reader.parseUnsignedIntVal();
        this.exceptionHandlerOffset = reader.parseVarSizedOffset(32);
        this.exceptionHandlerSectionID = reader.parseUnsignedShortVal();
        this.flags = reader.parseUnsignedIntVal();
        this.processFlags(this.flags);
    }

    @Override
    public int getPdbId() {
        return 4114;
    }

    public long getProcedureFrameTotalLength() {
        return this.procedureFrameTotalLength;
    }

    public long getProcedureFramePaddingLength() {
        return this.procedureFramePaddingLength;
    }

    public long getPaddingOffset() {
        return this.paddingOffset;
    }

    public long getCalleeSaveRegistersByteCount() {
        return this.calleeSaveRegistersByteCount;
    }

    public long getExceptionHandlerOffset() {
        return this.exceptionHandlerOffset;
    }

    public int getExceptionHandlerSectionID() {
        return this.exceptionHandlerSectionID;
    }

    public long getFlags() {
        return this.flags;
    }

    public boolean usesAlloca() {
        return this.usesAlloca;
    }

    public boolean usesSetJmp() {
        return this.usesSetJmp;
    }

    public boolean usesLongJmp() {
        return this.usesLongJmp;
    }

    public boolean usesInlineAsm() {
        return this.usesInlineAsm;
    }

    public boolean hasExceptionHandlingStates() {
        return this.hasExceptionHandlingStates;
    }

    public boolean wasInlineSpec() {
        return this.wasInlineSpec;
    }

    public boolean wasStructuredExceptionHandling() {
        return this.wasStructuredExceptionHandling;
    }

    public boolean isDeclspecNaked() {
        return this.isDeclspecNaked;
    }

    public boolean hasGsBufferSecurityCheck() {
        return this.hasGsBufferSecurityCheck;
    }

    public boolean isCompiledWithAsyncExceptionHandling() {
        return this.compiledWithAsyncExceptionHandling;
    }

    public boolean couldNotDoStackOrderingWithGsBufferSecurityChecks() {
        return this.couldNotDoStackOrderingWithGsBufferSecurityChecks;
    }

    public boolean wasInlinedWithinAnotherFunction() {
        return this.wasInlinedWithinAnotherFunction;
    }

    public boolean isDeclspecStrictGsCheck() {
        return this.isDeclspecStrictGsCheck;
    }

    public boolean isDeclspecSafeBuffers() {
        return this.isDeclspecSafeBuffers;
    }

    public RegisterName getExplicitlyEncodedLocalBasePointer() {
        return this.explicitlyEncodedLocalBasePointer;
    }

    public RegisterName getExplicitlyEncodedParameterPointer() {
        return this.explicitlyEncodedParameterPointer;
    }

    public boolean wasCompiledWithPgoPgu() {
        return this.wasCompiledWithPgoPgu;
    }

    public boolean hasvalidPogoCounts() {
        return this.hasvalidPogoCounts;
    }

    public boolean isOptimizedForSpeed() {
        return this.optimizedForSpeed;
    }

    public boolean containsCfgChecksButNoWriteChecks() {
        return this.containsCfgChecksButNoWriteChecks;
    }

    public boolean containsCfwChecksAndOrInstrumentation() {
        return this.containsCfwChecksAndOrInstrumentation;
    }

    public int getPadding() {
        return this.padding;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s:\n", this.getSymbolTypeName()));
        builder.append(String.format("   Frame size = %08X bytes\n", this.procedureFrameTotalLength));
        builder.append(String.format("   Pad size = %08X bytes\n", this.procedureFramePaddingLength));
        builder.append(String.format("   Offset of pad in frame = %08X\n", this.paddingOffset));
        builder.append(String.format("   Size of callee save registers = %08X\n", this.calleeSaveRegistersByteCount));
        builder.append(String.format("   Address of exception handler = %04X:%08X\n", this.exceptionHandlerSectionID, this.exceptionHandlerOffset));
        builder.append("   Function info: ");
        builder.append(this.usesAlloca ? "alloca " : "");
        builder.append(this.usesSetJmp ? "setjmp " : "");
        builder.append(this.usesLongJmp ? "longjmp " : "");
        builder.append(this.usesInlineAsm ? "inlasm " : "");
        builder.append(this.hasExceptionHandlingStates ? "eh  " : "");
        builder.append(this.wasInlineSpec ? "inl_specified " : "");
        builder.append(this.wasStructuredExceptionHandling ? "seh " : "");
        builder.append(this.isDeclspecNaked ? "naked " : "");
        builder.append(this.hasGsBufferSecurityCheck ? "gschecks " : "");
        builder.append(this.compiledWithAsyncExceptionHandling ? "asynceh " : "");
        builder.append(this.couldNotDoStackOrderingWithGsBufferSecurityChecks ? "gsnostackordering " : "");
        builder.append(this.wasInlinedWithinAnotherFunction ? "wasinlined " : "");
        builder.append(this.isDeclspecStrictGsCheck ? "strict_gs_check " : "");
        builder.append(this.isDeclspecSafeBuffers ? "safebuffers " : "");
        builder.append(this.wasCompiledWithPgoPgu ? "pgo_on " : "");
        builder.append(this.hasvalidPogoCounts ? "valid_pgo_counts " : "invalid_pgo_counts ");
        builder.append(this.optimizedForSpeed ? "opt_for_speed " : "");
        builder.append("Local=");
        this.explicitlyEncodedLocalBasePointer.emit(builder);
        builder.append(" ");
        builder.append("Param=");
        this.explicitlyEncodedParameterPointer.emit(builder);
        builder.append(" ");
        builder.append(this.containsCfgChecksButNoWriteChecks ? "guardcf " : "");
        builder.append(this.containsCfwChecksAndOrInstrumentation ? "guardcfw " : "");
        builder.append(String.format("(%08X)", this.flags));
    }

    @Override
    protected String getSymbolTypeName() {
        return "FRAMEPROCSYM";
    }

    private void processFlags(long flagsIn) {
        this.usesAlloca = (flagsIn & 1L) == 1L;
        this.usesSetJmp = ((flagsIn >>= 1) & 1L) == 1L;
        this.usesLongJmp = ((flagsIn >>= 1) & 1L) == 1L;
        this.usesInlineAsm = ((flagsIn >>= 1) & 1L) == 1L;
        this.hasExceptionHandlingStates = ((flagsIn >>= 1) & 1L) == 1L;
        this.wasInlineSpec = ((flagsIn >>= 1) & 1L) == 1L;
        this.wasStructuredExceptionHandling = ((flagsIn >>= 1) & 1L) == 1L;
        this.isDeclspecNaked = ((flagsIn >>= 1) & 1L) == 1L;
        this.hasGsBufferSecurityCheck = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithAsyncExceptionHandling = ((flagsIn >>= 1) & 1L) == 1L;
        this.couldNotDoStackOrderingWithGsBufferSecurityChecks = ((flagsIn >>= 1) & 1L) == 1L;
        this.wasInlinedWithinAnotherFunction = ((flagsIn >>= 1) & 1L) == 1L;
        this.isDeclspecStrictGsCheck = ((flagsIn >>= 1) & 1L) == 1L;
        this.isDeclspecSafeBuffers = ((flagsIn >>= 1) & 1L) == 1L;
        this.explicitlyEncodedLocalBasePointer = new RegisterName(this.pdb, (int)((flagsIn >>= 1) & 3L));
        this.explicitlyEncodedParameterPointer = new RegisterName(this.pdb, (int)((flagsIn >>= 2) & 3L));
        this.wasCompiledWithPgoPgu = ((flagsIn >>= 2) & 1L) == 1L;
        this.hasvalidPogoCounts = ((flagsIn >>= 1) & 1L) == 1L;
        this.optimizedForSpeed = ((flagsIn >>= 1) & 1L) == 1L;
        this.containsCfgChecksButNoWriteChecks = ((flagsIn >>= 1) & 1L) == 1L;
        this.containsCfwChecksAndOrInstrumentation = ((flagsIn >>= 1) & 1L) == 1L;
        this.padding = (int)((flagsIn >>= 1) & 0x1FFL);
    }
}

