/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.util.LittleEndianDataConverter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PdbByteReader {
    public static final PdbByteReader DUMMY = new PdbByteReader(new byte[0]);
    private byte[] bytes;
    private int limit;
    private int index;
    private int alignMarker;

    public PdbByteReader(byte[] bytes) {
        this.bytes = bytes;
        this.limit = bytes == null ? 0 : bytes.length;
        this.index = 0;
        this.alignMarker = 0;
    }

    public void reset() {
        this.index = 0;
        this.alignMarker = 0;
    }

    public int numRemaining() {
        return this.limit - this.index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setIndex(int index) {
        if (index >= 0 && index < this.limit) {
            this.index = index;
        }
    }

    public boolean hasMore() {
        return this.index < this.limit;
    }

    public boolean hasMoreNonPad() {
        if (!this.hasMore()) {
            return false;
        }
        return (this.bytes[this.index] & 0xFF) <= 240;
    }

    public int parseUnsignedByteVal() throws PdbException {
        this.checkLimit(1);
        return this.bytes[this.index++] & 0xFF;
    }

    public int parseVarSizedInt(int size) throws PdbException {
        switch (size) {
            case 16: {
                return this.parseShort();
            }
            case 32: {
                return this.parseInt();
            }
        }
        throw new PdbException("Bad int size");
    }

    public int parseSmallVarSizedUInt(int size) throws PdbException {
        switch (size) {
            case 8: {
                return this.parseUnsignedByteVal();
            }
            case 16: {
                return this.parseUnsignedShortVal();
            }
        }
        throw new PdbException("Bad int size");
    }

    public long parseVarSizedUInt(int size) throws PdbException {
        switch (size) {
            case 8: {
                return this.parseUnsignedByteVal();
            }
            case 16: {
                return this.parseUnsignedShortVal();
            }
            case 32: {
                return this.parseUnsignedIntVal();
            }
        }
        throw new PdbException("Bad int size");
    }

    public long parseVarSizedOffset(int size) throws PdbException {
        switch (size) {
            case 16: {
                return this.parseUnsignedShortVal();
            }
            case 32: {
                return this.parseUnsignedIntVal();
            }
        }
        throw new PdbException("Bad offset size");
    }

    public int parseVarSizedCount(int size) throws PdbException {
        switch (size) {
            case 16: {
                return this.parseUnsignedShortVal();
            }
            case 32: {
                return this.parseInt();
            }
        }
        throw new PdbException("Bad count size");
    }

    public short parseShort() throws PdbException {
        this.checkLimit(2);
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + 2);
        this.index += 2;
        return LittleEndianDataConverter.INSTANCE.getShort(selectedBytes);
    }

    public int parseUnsignedShortVal() throws PdbException {
        this.checkLimit(2);
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + 2);
        selectedBytes = Arrays.copyOf(selectedBytes, 4);
        this.index += 2;
        return LittleEndianDataConverter.INSTANCE.getInt(selectedBytes);
    }

    public int parseInt() throws PdbException {
        this.checkLimit(4);
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + 4);
        this.index += 4;
        return LittleEndianDataConverter.INSTANCE.getInt(selectedBytes);
    }

    public long parseUnsignedIntVal() throws PdbException {
        this.checkLimit(4);
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + 4);
        selectedBytes = Arrays.copyOf(selectedBytes, 8);
        this.index += 4;
        return LittleEndianDataConverter.INSTANCE.getLong(selectedBytes);
    }

    public long parseLong() throws PdbException {
        this.checkLimit(8);
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + 8);
        this.index += 8;
        return LittleEndianDataConverter.INSTANCE.getLong(selectedBytes);
    }

    public BigInteger parseUnsignedLongVal() throws PdbException {
        this.checkLimit(8);
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + 8);
        selectedBytes = Arrays.copyOf(selectedBytes, 8);
        this.index += 8;
        return LittleEndianDataConverter.INSTANCE.getBigInteger(selectedBytes, 8, false);
    }

    public byte[] parseShortLengthPrefixedByteArray() throws PdbException {
        this.checkLimit(2);
        int length = this.parseUnsignedShortVal();
        this.checkLimit(length);
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + length);
        this.index += length;
        return selectedBytes;
    }

    public byte[] parseBytesRemaining() {
        int remaining = this.limit - this.index;
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + remaining);
        this.index += remaining;
        return selectedBytes;
    }

    public byte[] parseBytes(int num) throws PdbException {
        this.checkLimit(num);
        byte[] selectedBytes = Arrays.copyOfRange(this.bytes, this.index, this.index + num);
        this.index += num;
        return selectedBytes;
    }

    public PdbByteReader getSubPdbByteReader(int length) throws PdbException {
        return new PdbByteReader(this.parseBytes(length));
    }

    public GUID parseGUID() throws PdbException {
        this.checkLimit(16);
        int data1 = this.parseInt();
        short data2 = this.parseShort();
        short data3 = this.parseShort();
        byte[] data4 = this.parseBytes(8);
        return new GUID(data1, data2, data3, data4);
    }

    public String parseString(AbstractPdb pdb, StringParseType stType) throws PdbException {
        switch (stType) {
            case StringNt: {
                return this.parseNullTerminatedString(pdb.getPdbReaderOptions().getOneByteCharset());
            }
            case StringSt: {
                return this.parseByteLengthPrefixedString(pdb.getPdbReaderOptions().getOneByteCharset());
            }
            case StringUtf8St: {
                return this.parseByteLengthPrefixedUtf8String();
            }
            case StringUtf8Nt: {
                return this.parseNullTerminatedUtf8String();
            }
            case StringWcharNt: {
                return this.parseNullTerminatedWcharString(pdb.getPdbReaderOptions().getTwoByteCharset());
            }
        }
        throw new PdbException("Bad string type");
    }

    public String parseByteLengthPrefixedString(Charset charset) throws PdbException {
        int length = this.parseUnsignedByteVal();
        if (length == 0) {
            return "";
        }
        int offset = this.index;
        this.index += length;
        try {
            return new String(this.bytes, offset, length, charset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdbException("Error parsing String: " + e.toString());
        }
    }

    public String parseByteLengthPrefixedUtf8String() throws PdbException {
        int length = this.parseUnsignedByteVal();
        if (length == 0) {
            return "";
        }
        int offset = this.index;
        this.index += length;
        try {
            return new String(this.bytes, offset, length, StandardCharsets.UTF_8);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PdbException("Error parsing String: " + e.toString());
        }
    }

    public String parseNullTerminatedString(Charset charset) {
        int offset = this.index;
        int width = 1;
        int end = this.findNullTerminatorIndex(width);
        this.index = end + width;
        if (end == offset) {
            return "";
        }
        return new String(this.bytes, offset, end - offset, charset);
    }

    public String parseNullTerminatedUtf8String() {
        int offset = this.index;
        int width = 1;
        int end = this.findNullTerminatorIndex(width);
        this.index = end + width;
        if (end == offset) {
            return "";
        }
        return new String(this.bytes, offset, end - offset, StandardCharsets.UTF_8);
    }

    public String parseNullTerminatedWcharString(Charset charset) {
        int offset = this.index;
        int width = 2;
        int end = this.findNullTerminatorIndex(width);
        this.index = end + width;
        if (end == offset) {
            return "";
        }
        return new String(this.bytes, offset, end - offset, charset);
    }

    public void markAlign(int alignMarkerIn) {
        this.alignMarker = alignMarkerIn;
    }

    public int align4() {
        int excess = this.index - this.alignMarker & 3;
        int pad = excess == 0 ? 0 : 4 - excess;
        this.index += pad;
        return pad;
    }

    public int skipPadding() {
        int initialIndex = this.index;
        while (this.index < this.limit && (this.bytes[this.index] & 0xF0) == 240) {
            ++this.index;
        }
        return this.index - initialIndex;
    }

    public void skip(int num) {
        this.index = num > this.limit - this.index ? this.limit : (this.index += num);
    }

    public String dump() {
        return this.dump(0, this.limit);
    }

    public String dump(int max) {
        return this.dump(this.index, this.index + max);
    }

    public String dump(int first, int last) {
        StringBuilder builder = new StringBuilder();
        last = last > this.limit ? this.limit : last;
        builder.append("limit: ");
        builder.append(this.limit);
        builder.append("\nindex: ");
        builder.append(this.index);
        builder.append("\nfirst: ");
        builder.append(first);
        builder.append("\nlast: ");
        builder.append(last);
        builder.append(this.dumpBytes(first, last));
        return builder.toString();
    }

    public String dumpBytes() {
        return this.dumpBytes(0, this.limit);
    }

    public String dumpBytes(int max) {
        return this.dumpBytes(this.index, this.index + max);
    }

    public String dumpBytes(int first, int last) {
        if (first > last || first > this.limit) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        last = last > this.limit ? this.limit : last;
        int i = first;
        while (i < last) {
            builder.append(String.format("\n%06x", i));
            for (int j = 0; j < 16 && i < last; ++j, ++i) {
                builder.append(String.format(" %02x", this.bytes[i]));
            }
        }
        return builder.toString();
    }

    private void checkLimit(int numNeeded) throws PdbException {
        if (numNeeded < 0) {
            throw new PdbException("Illegal negative.");
        }
        if (Integer.MAX_VALUE - this.index < numNeeded) {
            throw new PdbException("Needed data beyond max.");
        }
        if (this.index + numNeeded > this.limit) {
            throw new PdbException("Needed data is not available.");
        }
    }

    private int findNullTerminatorIndex(int width) {
        int count = 0;
        int finderIndex = this.index;
        while (finderIndex < this.limit) {
            if (this.bytes[finderIndex++] == 0) {
                if (++count != width) continue;
                return finderIndex - width;
            }
            count = 0;
        }
        return this.limit;
    }
}

