/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProportionalHorizontalLayout
implements LayoutManager2 {
    protected final Map<Component, Double> components = new LinkedHashMap<Component, Double>();

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof Proportion)) {
            throw new IllegalArgumentException();
        }
        Proportion w = (Proportion)constraints;
        this.components.put(comp, w.p);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.components.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        double totalP = this.components.values().stream().reduce(0.0, Double::sum);
        Dimension result = new Dimension();
        for (Map.Entry<Component, Double> ent : this.components.entrySet()) {
            double fraction = ent.getValue() / totalP;
            if (fraction == 0.0) continue;
            Dimension size = ent.getKey().getPreferredSize();
            result.width = Math.max(result.width, (int)Math.ceil((double)size.width / fraction));
            result.height = Math.max(result.height, size.height);
        }
        return result;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        double totalP = this.components.values().stream().reduce(0.0, Double::sum);
        Dimension result = new Dimension();
        for (Map.Entry<Component, Double> ent : this.components.entrySet()) {
            double fraction = ent.getValue() / totalP;
            if (fraction == 0.0) continue;
            Dimension size = ent.getKey().getMinimumSize();
            result.width = Math.max(result.width, (int)Math.ceil((double)size.width / fraction));
            result.height = Math.max(result.height, size.height);
        }
        return result;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension pDim = parent.getSize();
        double totalWeight = this.components.values().stream().reduce(0.0, Double::sum);
        double running = 0.0;
        Rectangle cur = new Rectangle();
        cur.x = 0;
        cur.y = 0;
        cur.height = pDim.height;
        for (Map.Entry<Component, Double> ent : this.components.entrySet()) {
            double w = ent.getValue();
            int newX = (int)((double)pDim.width * (running += w) / totalWeight);
            cur.width = newX - cur.x;
            ent.getKey().setBounds(cur);
            cur.x = newX;
        }
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    public static class Proportion {
        private final double p;

        public Proportion(double p) {
            this.p = p;
        }
    }
}

