/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.reader;

import com.googlecode.d2j.reader.BaseDexFileReader;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.util.zip.AccessBufByteArrayOutputStream;
import com.googlecode.d2j.util.zip.ZipEntry;
import com.googlecode.d2j.util.zip.ZipFile;
import com.googlecode.d2j.visitors.DexFileVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class MultiDexFileReader
implements BaseDexFileReader {
    private final List<DexFileReader> readers = new ArrayList<DexFileReader>();
    private final List<Item> items = new ArrayList<Item>();

    public MultiDexFileReader(Collection<DexFileReader> readers) {
        this.readers.addAll(readers);
        this.init();
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        AccessBufByteArrayOutputStream out = new AccessBufByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int c = is.read(buff);
        while (c > 0) {
            out.write(buff, 0, c);
            c = is.read(buff);
        }
        return out.getBuf();
    }

    public static BaseDexFileReader open(InputStream in) throws IOException {
        return MultiDexFileReader.open(MultiDexFileReader.toByteArray(in));
    }

    public static BaseDexFileReader open(byte[] data) throws IOException {
        if (data.length < 3) {
            throw new IOException("File too small to be a dex/zip");
        }
        if ("dex".equals(new String(data, 0, 3, StandardCharsets.ISO_8859_1))) {
            return new DexFileReader(data);
        }
        if ("PK".equals(new String(data, 0, 2, StandardCharsets.ISO_8859_1))) {
            TreeMap<String, DexFileReader> dexFileReaders = new TreeMap<String, DexFileReader>();
            try (ZipFile zipFile = new ZipFile(data);){
                for (ZipEntry zipEntry : zipFile.entries()) {
                    String entryName = zipEntry.getName();
                    if (!entryName.startsWith("classes") || !entryName.endsWith(".dex") || dexFileReaders.containsKey(entryName)) continue;
                    dexFileReaders.put(entryName, new DexFileReader(MultiDexFileReader.toByteArray(zipFile.getInputStream(zipEntry))));
                }
            }
            if (dexFileReaders.isEmpty()) {
                throw new IOException("Can not find classes.dex in zip file");
            }
            if (dexFileReaders.size() == 1) {
                return (BaseDexFileReader)dexFileReaders.firstEntry().getValue();
            }
            return new MultiDexFileReader(dexFileReaders.values());
        }
        throw new IOException("The source file is not a .dex or .zip file");
    }

    void init() {
        HashSet<String> classes = new HashSet<String>();
        for (DexFileReader reader : this.readers) {
            List<String> classNames = reader.getClassNames();
            for (int i = 0; i < classNames.size(); ++i) {
                String className = classNames.get(i);
                if (!classes.add(className)) continue;
                this.items.add(new Item(i, reader, className));
            }
        }
    }

    @Override
    public int getDexVersion() {
        return this.readers.stream().mapToInt(DexFileReader::getDexVersion).max().orElse(0x303335);
    }

    @Override
    public void accept(DexFileVisitor dv) {
        this.accept(dv, 0);
    }

    @Override
    public List<String> getClassNames() {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((Item)((MultiDexFileReader)MultiDexFileReader.this).items.get((int)index)).className;
            }

            @Override
            public int size() {
                return MultiDexFileReader.this.items.size();
            }
        };
    }

    @Override
    public void accept(DexFileVisitor dv, int config) {
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            this.accept(dv, i, config);
        }
    }

    @Override
    public void accept(DexFileVisitor dv, int classIdx, int config) {
        Item item = this.items.get(classIdx);
        item.reader.accept(dv, item.idx, config);
    }

    static class Item {
        int idx;
        DexFileReader reader;
        String className;

        Item(int i, DexFileReader reader, String className) {
            this.idx = i;
            this.reader = reader;
            this.className = className;
        }
    }
}

