/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import docking.widgets.checkbox.GCheckBox;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.gui.filters.CheckBoxBasedAncillaryFilter;
import ghidra.feature.vt.gui.filters.CheckBoxInfo;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class MarkupStatusFilter
extends CheckBoxBasedAncillaryFilter<VTMarkupItem> {
    public MarkupStatusFilter() {
        super("Markup Status");
    }

    @Override
    protected void createCheckBoxInfos() {
        VTMarkupItemStatus[] values;
        ItemListener listener = e -> this.fireStatusChanged(this.getFilterStatus());
        for (VTMarkupItemStatus status : values = VTMarkupItemStatus.values()) {
            GCheckBox checkBox = new GCheckBox(status.getDescription());
            checkBox.setSelected(true);
            checkBox.addItemListener(listener);
            MatchStatusCheckBoxInfo info = new MatchStatusCheckBoxInfo(this, (JCheckBox)checkBox, status);
            this.checkBoxInfos.add(info);
        }
    }

    private class MatchStatusCheckBoxInfo
    extends CheckBoxInfo<VTMarkupItem> {
        private VTMarkupItemStatus status;

        public MatchStatusCheckBoxInfo(MarkupStatusFilter markupStatusFilter, JCheckBox checkBox, VTMarkupItemStatus status) {
            super(checkBox);
            this.status = status;
        }

        @Override
        public boolean matchesStatus(VTMarkupItem adapter) {
            if (!this.isSelected()) {
                return false;
            }
            return adapter.getStatus().equals((Object)this.status);
        }
    }
}

