/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import ghidra.framework.main.datatree.DomainFilesPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class UndoActionDialog
extends DialogComponentProvider {
    static final int OK = 0;
    public static final int CANCEL = 1;
    private List<DomainFile> fileList;
    private DomainFilesPanel filePanel;
    private JCheckBox saveCopyCB;
    private int actionID;

    public UndoActionDialog(String title, Icon icon, String helpTag, String actionString, List<DomainFile> fileList) {
        super(title, true);
        this.setHelpLocation(new HelpLocation("Repository", helpTag));
        this.fileList = fileList;
        this.addWorkPanel(this.buildMainPanel(actionString, icon));
        this.addOKButton();
        this.addCancelButton();
    }

    protected void cancelCallback() {
        this.actionID = 1;
        this.close();
    }

    protected void okCallback() {
        this.actionID = 0;
        this.close();
    }

    public int showDialog(PluginTool tool) {
        tool.showDialog(this);
        return this.actionID;
    }

    public DomainFile[] getSelectedDomainFiles() {
        return this.filePanel.getSelectedDomainFiles();
    }

    public boolean saveCopy() {
        return this.saveCopyCB.isSelected();
    }

    private JPanel buildMainPanel(String actionString, Icon icon) {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.filePanel = new DomainFilesPanel(this.fileList, null);
        this.saveCopyCB = new GCheckBox("Save copy of the file with a .keep extension", true);
        JPanel cbPanel = new JPanel(new BorderLayout());
        cbPanel.add(this.saveCopyCB);
        JPanel iconPanel = new JPanel(new BorderLayout(10, 0));
        iconPanel.add((Component)new GIconLabel(icon), "West");
        iconPanel.add((Component)new GLabel("Undo " + actionString + " of the selected files:", 2), "Center");
        innerPanel.add(Box.createVerticalStrut(10));
        innerPanel.add(iconPanel);
        innerPanel.add(Box.createVerticalStrut(5));
        innerPanel.add(this.filePanel);
        innerPanel.add(Box.createVerticalStrut(10));
        innerPanel.add(cbPanel);
        return innerPanel;
    }
}

