/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import generic.cache.BasicFactory;
import generic.cache.CachingPool;
import generic.cache.CountingBasicFactory;
import generic.concurrent.QCallback;
import generic.jar.ResourceFile;
import generic.lsh.LSHMemoryModel;
import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.WeightedLSHCosineVectorFactory;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.decompiler.signature.SignatureResult;
import ghidra.feature.vt.api.BSimProgramCorrelatorFactory;
import ghidra.feature.vt.api.BSimProgramCorrelatorMatching;
import ghidra.feature.vt.api.FunctionNode;
import ghidra.feature.vt.api.FunctionNodeContainer;
import ghidra.feature.vt.api.FunctionPair;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelator;
import ghidra.feature.vt.api.util.VTFunctionSizeUtil;
import ghidra.features.bsim.query.GenSignatures;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class BSimProgramCorrelator
extends VTAbstractProgramCorrelator {
    private LSHVectorFactory vectorFactory = new WeightedLSHCosineVectorFactory();
    private static final int TIMEOUT = 60;
    public static final double SIMILARITY_THRESHOLD = 0.5;
    public static final int FUNCTION_MINIMUM_SIZE = 0;

    protected BSimProgramCorrelator(Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, ToolOptions options) {
        super(sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options);
    }

    public String getName() {
        return "BSim Function Matching";
    }

    protected void doCorrelate(VTMatchSet matchSet, TaskMonitor monitor) throws CancelledException {
        List<FunctionPair> result;
        ToolOptions options = this.getOptions();
        LSHMemoryModel model = (LSHMemoryModel)options.getEnum("Memory Model", (Enum)BSimProgramCorrelatorFactory.MEMORY_MODEL_DEFAULT);
        double confThreshold = options.getDouble("Confidence Threshold for a Seed", 10.0);
        double impThreshold = options.getDouble("Confidence Threshold for a Match", 0.0);
        boolean useAcceptedMatchesAsSeeds = options.getBoolean("Use Accepted Matches as Seeds", true);
        boolean useNamespace = false;
        boolean useCallRefs = false;
        try {
            LanguageID id1 = this.getSourceProgram().getLanguageID();
            LanguageID id2 = this.getDestinationProgram().getLanguageID();
            ResourceFile defaultWeightsFile = GenSignatures.getWeightsFile((LanguageID)id1, (LanguageID)id2);
            if (defaultWeightsFile == null) {
                Msg.showWarn((Object)((Object)this), null, (String)"Cannot Compare Programs", (Object)("<html>Cannot currently compare programs with such different architectures.<br>Source program is " + id1.getIdAsString() + "<br>Destination program is " + id2.getIdAsString()));
                return;
            }
            if (defaultWeightsFile.getName().contains("cpool")) {
                useNamespace = true;
                useCallRefs = true;
            }
            InputStream input = defaultWeightsFile.getInputStream();
            NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl(input, "Vector weights parser", SpecXmlUtils.getXmlHandler(), false);
            this.vectorFactory.readWeights((XmlPullParser)parser);
            input.close();
            monitor.setMessage("Generating source dictionary");
            List<FunctionNode> rawSourceNodes = this.generateNodes(this.getSourceProgram(), this.getSourceAddressSet(), useCallRefs, monitor);
            FunctionNodeContainer sourceNodes = new FunctionNodeContainer(this.getSourceProgram(), rawSourceNodes);
            monitor.setMessage("Generating destination dictionary");
            List<FunctionNode> rawDestNodes = this.generateNodes(this.getDestinationProgram(), this.getDestinationAddressSet(), useCallRefs, monitor);
            FunctionNodeContainer destNodes = new FunctionNodeContainer(this.getDestinationProgram(), rawDestNodes);
            BSimProgramCorrelatorMatching omni = new BSimProgramCorrelatorMatching(sourceNodes, destNodes, this.vectorFactory, confThreshold, impThreshold, 0.5, useNamespace, model);
            omni.discoverPotentialMatches(monitor);
            if (!omni.generateSeeds(matchSet, useAcceptedMatchesAsSeeds, monitor)) {
                Msg.info((Object)((Object)this), (Object)"BSim Program Correlator could not find any seeds");
            }
            result = omni.doMatching(monitor);
        }
        catch (InterruptedException e) {
            Msg.error((Object)((Object)this), (Object)"Error Correlating", (Throwable)e.getCause());
            CancelledException cancelledException = new CancelledException();
            cancelledException.initCause((Throwable)e);
            throw cancelledException;
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Error Correlating", (Throwable)e.getCause());
            CancelledException cancelledException = new CancelledException();
            cancelledException.initCause((Throwable)e);
            throw cancelledException;
        }
        BSimProgramCorrelator.wrapUp(result, matchSet, monitor);
    }

    private static void addExternalFunctions(Program program, List<FunctionNode> list, LSHVectorFactory vFactory, TaskMonitor monitor) throws CancelledException {
        FunctionIterator iter = program.getFunctionManager().getExternalFunctions();
        int[] externalFeatures = new int[]{-86090003};
        LSHVector externalVector = vFactory.buildVector(externalFeatures);
        while (iter.hasNext()) {
            monitor.checkCancelled();
            Function func = (Function)iter.next();
            FunctionNode node = new FunctionNode(func, externalVector, new ArrayList<Address>());
            list.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FunctionNode> generateNodes(Program program, AddressSetView addrSet, boolean useCallRefs, TaskMonitor monitor) throws InterruptedException, CancelledException, Exception {
        monitor.checkCancelled();
        CachingPool decompilerPool = new CachingPool((BasicFactory)new DecompilerFactory(program, this.vectorFactory.getSettings()));
        ParallelDecompilerCallback callback = new ParallelDecompilerCallback((CachingPool<DecompInterface>)decompilerPool, this.vectorFactory, useCallRefs);
        List results = null;
        try {
            AddressSetView refinedAddressSet = VTFunctionSizeUtil.minimumSizeFunctionFilter((Program)program, (AddressSetView)addrSet, (int)0, (TaskMonitor)monitor);
            results = ParallelDecompiler.decompileFunctions((QCallback)callback, (Program)program, (AddressSetView)refinedAddressSet, (TaskMonitor)monitor);
        }
        finally {
            decompilerPool.dispose();
        }
        BSimProgramCorrelator.addExternalFunctions(program, results, this.vectorFactory, monitor);
        monitor.setMessage("Collecting dictionary results");
        return results;
    }

    private static void wrapUp(List<FunctionPair> result, VTMatchSet matchSet, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Adding results to database");
        monitor.setIndeterminate(false);
        monitor.initialize((long)result.size());
        int ii = 0;
        for (FunctionPair resMatch : result) {
            VTMatchInfo match = resMatch.getMatch(matchSet);
            if (++ii % 1000 == 0) {
                monitor.checkCancelled();
                monitor.incrementProgress(1000L);
            }
            matchSet.addMatch(match);
        }
    }

    private static DecompileOptions getDecompilerOptions(Program program) {
        DecompileOptions options = new DecompileOptions();
        options.setNoCastPrint(true);
        try {
            PrototypeModel model = program.getCompilerSpec().getPrototypeEvaluationModel(CompilerSpec.EvaluationModelType.EVAL_CURRENT);
            options.setProtoEvalModel(model.getName());
        }
        catch (Exception e) {
            Msg.warn(BSimProgramCorrelator.class, (Object)("problem setting prototype evaluation model: " + e.getMessage()));
        }
        options.setDefaultTimeout(60);
        return options;
    }

    private static class DecompilerFactory
    extends CountingBasicFactory<DecompInterface> {
        private Program program;
        private int settings;

        DecompilerFactory(Program program, int set) {
            this.program = program;
            this.settings = set;
        }

        public DecompInterface doCreate(int itemNumber) throws IOException {
            DecompInterface decompiler = new DecompInterface();
            decompiler.setOptions(BSimProgramCorrelator.getDecompilerOptions(this.program));
            decompiler.setSignatureSettings(this.settings);
            if (!decompiler.openProgram(this.program)) {
                throw new IOException(decompiler.getLastMessage());
            }
            return decompiler;
        }

        public void doDispose(DecompInterface decompiler) {
            decompiler.dispose();
        }
    }

    private static class ParallelDecompilerCallback
    implements QCallback<Function, FunctionNode> {
        private LSHVectorFactory vectorFactory;
        private CachingPool<DecompInterface> pool;
        private boolean callsByReference;

        ParallelDecompilerCallback(CachingPool<DecompInterface> decompilerPool, LSHVectorFactory vFactory, boolean refCalls) {
            this.vectorFactory = vFactory;
            this.pool = decompilerPool;
            this.callsByReference = refCalls;
        }

        private ArrayList<Address> getCallAddressesByReference(Function function, TaskMonitor monitor) throws CancelledException {
            ArrayList<Address> resultList = new ArrayList<Address>();
            Program program = function.getProgram();
            ReferenceManager referenceManager = program.getReferenceManager();
            AddressSetView addresses = function.getBody();
            AddressIterator addressIterator = addresses.getAddresses(true);
            while (addressIterator.hasNext()) {
                monitor.checkCancelled();
                Address address = addressIterator.next();
                Reference[] referencesFrom = referenceManager.getReferencesFrom(address);
                if (referencesFrom == null) continue;
                for (Reference reference : referencesFrom) {
                    if (!reference.getReferenceType().isCall()) continue;
                    resultList.add(reference.getToAddress());
                }
            }
            return resultList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FunctionNode process(Function function, TaskMonitor monitor) throws Exception {
            monitor.checkCancelled();
            DecompInterface decompiler = (DecompInterface)this.pool.get();
            try {
                String errmsg;
                LSHVector vec = null;
                ArrayList<Address> callAddresses = null;
                SignatureResult sigres = decompiler.generateSignatures(function, !this.callsByReference, 60, monitor);
                if (sigres == null) {
                    callAddresses = new ArrayList<Address>();
                } else {
                    vec = this.vectorFactory.buildVector(sigres.features);
                    callAddresses = this.callsByReference ? this.getCallAddressesByReference(function, monitor) : sigres.calllist;
                }
                FunctionNode res = new FunctionNode(function, vec, callAddresses);
                if (res.getVector() == null && (errmsg = decompiler.getLastMessage()).startsWith("Bad command")) {
                    throw new DecompileException("BSim Function Matching", errmsg);
                }
                FunctionNode functionNode = res;
                return functionNode;
            }
            finally {
                this.pool.release((Object)decompiler);
            }
        }
    }
}

