/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class FunctionEntry {
    public String funcName;
    public long address;

    private FunctionEntry() {
    }

    public FunctionEntry(FunctionDescription desc) {
        this.funcName = desc.getFunctionName();
        this.address = desc.getAddress();
    }

    public void saveXml(Writer writer) throws IOException {
        writer.append("<fentry name=\"");
        SpecXmlUtils.xmlEscapeWriter((Writer)writer, (String)this.funcName);
        writer.append("\" addr=\"0x");
        writer.append(Long.toHexString(this.address));
        writer.append("\"/>\n");
    }

    public static FunctionEntry restoreXml(XmlPullParser parser) {
        FunctionEntry functionEntry = new FunctionEntry();
        XmlElement startEl = parser.start(new String[]{"fentry"});
        functionEntry.funcName = startEl.getAttribute("name");
        functionEntry.address = SpecXmlUtils.decodeLong((String)startEl.getAttribute("addr"));
        parser.end(startEl);
        return functionEntry;
    }
}

