/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.overview;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.features.bsim.query.protocol.SimilarityVectorResult;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;

public class BSimOverviewRowObject {
    private Address addr;
    private SimilarityVectorResult simvec;
    private double selfsignif;
    private long vectorHash;
    private Function function;

    public BSimOverviewRowObject(SimilarityVectorResult result, Address ad, LSHVectorFactory vectorFactory, Program program) {
        this.addr = ad;
        this.simvec = result;
        FunctionDescription func = this.simvec.getBase();
        this.selfsignif = 0.0;
        SignatureRecord sigrec = func.getSignatureRecord();
        if (sigrec != null) {
            this.selfsignif = vectorFactory.getSelfSignificance(sigrec.getLSHVector());
        }
        LSHVector lshVector = func.getSignatureRecord().getLSHVector();
        this.vectorHash = lshVector.calcUniqueHash();
        this.function = program.getFunctionManager().getFunctionAt(ad);
    }

    public String getFunctionName() {
        if (this.function == null || this.function.isDeleted()) {
            return null;
        }
        return this.function.getName();
    }

    public Address getFunctionEntryPoint() {
        return this.addr;
    }

    public int getHitCount() {
        return this.simvec.getTotalCount();
    }

    public double getSelfSignificance() {
        return this.selfsignif;
    }

    public long getVectorHash() {
        return this.vectorHash;
    }
}

