/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.Pair;
import generic.stl.RedBlackNode;
import java.util.Comparator;

public class RedBlackTree<K, V> {
    public static final String EOL = System.getProperty("line.separator");
    private RedBlackNode<K, V> root;
    private int size;
    private final Comparator<K> comparator;
    private final boolean allowDuplicateKeys;

    public RedBlackTree(Comparator<K> comparator, boolean allowDuplicateKeys) {
        this.comparator = comparator;
        this.allowDuplicateKeys = allowDuplicateKeys;
    }

    public RedBlackTree(RedBlackTree<K, V> tree) {
        this.comparator = tree.comparator;
        this.allowDuplicateKeys = tree.allowDuplicateKeys;
        for (RedBlackNode<K, V> node = tree.getFirst(); node != null; node = node.getSuccessor()) {
            this.put(node.key, node.value);
        }
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer("RedBlackTree[size=" + this.size + "]\n");
        int showSize = Math.min(20, this.size());
        RedBlackNode<K, V> current = this.getFirst();
        for (int i = 0; i < showSize; ++i) {
            buffy.append("\t[").append(i).append("]=(").append(current.key).append(",").append(current.value).append(")").append(EOL);
            current = current.getSuccessor();
        }
        return buffy.toString();
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(K key) {
        RedBlackNode<K, V> node = this.root;
        while (node != null) {
            int comp = this.comparator.compare(key, node.key);
            if (comp == 0) {
                return true;
            }
            if (comp < 0) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return false;
    }

    public RedBlackNode<K, V> getFirst() {
        if (this.root == null) {
            return null;
        }
        RedBlackNode<K, V> node = this.root;
        while (node.left != null) {
            node = node.left;
        }
        return node;
    }

    public RedBlackNode<K, V> getLast() {
        if (this.root == null) {
            return null;
        }
        RedBlackNode<K, V> node = this.root;
        while (node.right != null) {
            node = node.right;
        }
        return node;
    }

    public RedBlackNode<K, V> lowerBound(K key) {
        RedBlackNode<K, V> bestNode = null;
        RedBlackNode<K, V> node = this.root;
        while (node != null) {
            int result = this.comparator.compare(key, node.key);
            if (result <= 0) {
                bestNode = node;
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return bestNode;
    }

    public RedBlackNode<K, V> upperBound(K key) {
        RedBlackNode<K, V> bestNode = null;
        RedBlackNode<K, V> node = this.root;
        while (node != null) {
            int result = this.comparator.compare(key, node.key);
            if (result < 0) {
                bestNode = node;
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return bestNode;
    }

    public Pair<RedBlackNode<K, V>, Boolean> put(K key, V value) {
        if (this.root == null) {
            ++this.size;
            this.root = new RedBlackNode<K, V>(key, value, null);
            return new Pair<RedBlackNode<K, V>, Boolean>(this.root, Boolean.TRUE);
        }
        RedBlackNode<K, V> node = this.root;
        while (true) {
            int comp;
            if ((comp = this.comparator.compare(key, node.key)) == 0 && !this.allowDuplicateKeys) {
                node.value = value;
                return new Pair<RedBlackNode<K, V>, Boolean>(node, Boolean.FALSE);
            }
            if (comp < 0) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                ++this.size;
                RedBlackNode<K, V> newNode = new RedBlackNode<K, V>(key, value, node);
                node.left = newNode;
                this.fixAfterInsertion(newNode);
                return new Pair<RedBlackNode<K, V>, Boolean>(newNode, Boolean.TRUE);
            }
            if (node.right == null) break;
            node = node.right;
        }
        ++this.size;
        RedBlackNode<K, V> newNode = new RedBlackNode<K, V>(key, value, node);
        node.right = newNode;
        this.fixAfterInsertion(newNode);
        return new Pair<RedBlackNode<K, V>, Boolean>(newNode, Boolean.TRUE);
    }

    public RedBlackNode<K, V> findFirstNode(K key) {
        RedBlackNode<K, V> node = this.root;
        RedBlackNode<K, V> bestNode = null;
        while (node != null) {
            int comp = this.comparator.compare(key, node.key);
            if (comp == 0) {
                bestNode = node;
            }
            if (comp <= 0) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return bestNode;
    }

    public RedBlackNode<K, V> findLastNode(K key) {
        RedBlackNode<K, V> node = this.root;
        RedBlackNode<K, V> bestNode = null;
        while (node != null) {
            int comp = this.comparator.compare(key, node.key);
            if (comp == 0) {
                bestNode = node;
            }
            if (comp < 0) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return bestNode;
    }

    public V remove(K key) {
        RedBlackNode<K, V> node = this.findFirstNode(key);
        if (node == null) {
            return null;
        }
        Object value = node.value;
        this.deleteEntry(node);
        return value;
    }

    public void removeAll() {
        this.size = 0;
        this.root = null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private static <K, V> RedBlackNode.NodeColor colorOf(RedBlackNode<K, V> p) {
        return p == null ? RedBlackNode.NodeColor.BLACK : p.color;
    }

    private static <K, V> RedBlackNode<K, V> parentOf(RedBlackNode<K, V> p) {
        return p == null ? null : p.parent;
    }

    private static <K, V> void setColor(RedBlackNode<K, V> p, RedBlackNode.NodeColor c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <K, V> RedBlackNode<K, V> leftOf(RedBlackNode<K, V> p) {
        return p == null ? null : p.left;
    }

    private static <K, V> RedBlackNode<K, V> rightOf(RedBlackNode<K, V> p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(RedBlackNode<K, V> p) {
        RedBlackNode r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(RedBlackNode<K, V> p) {
        RedBlackNode l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(RedBlackNode<K, V> x) {
        x.color = RedBlackNode.NodeColor.RED;
        while (x != null && x != this.root && x.parent.color == RedBlackNode.NodeColor.RED) {
            RedBlackNode<K, V> y;
            if (RedBlackTree.parentOf(x) == RedBlackTree.leftOf(RedBlackTree.parentOf(RedBlackTree.parentOf(x)))) {
                y = RedBlackTree.rightOf(RedBlackTree.parentOf(RedBlackTree.parentOf(x)));
                if (RedBlackTree.colorOf(y) == RedBlackNode.NodeColor.RED) {
                    RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackNode.NodeColor.BLACK);
                    RedBlackTree.setColor(y, RedBlackNode.NodeColor.BLACK);
                    RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(x)), RedBlackNode.NodeColor.RED);
                    x = RedBlackTree.parentOf(RedBlackTree.parentOf(x));
                    continue;
                }
                if (x == RedBlackTree.rightOf(RedBlackTree.parentOf(x))) {
                    x = RedBlackTree.parentOf(x);
                    this.rotateLeft(x);
                }
                RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackNode.NodeColor.BLACK);
                RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(x)), RedBlackNode.NodeColor.RED);
                if (RedBlackTree.parentOf(RedBlackTree.parentOf(x)) == null) continue;
                this.rotateRight(RedBlackTree.parentOf(RedBlackTree.parentOf(x)));
                continue;
            }
            y = RedBlackTree.leftOf(RedBlackTree.parentOf(RedBlackTree.parentOf(x)));
            if (RedBlackTree.colorOf(y) == RedBlackNode.NodeColor.RED) {
                RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackNode.NodeColor.BLACK);
                RedBlackTree.setColor(y, RedBlackNode.NodeColor.BLACK);
                RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(x)), RedBlackNode.NodeColor.RED);
                x = RedBlackTree.parentOf(RedBlackTree.parentOf(x));
                continue;
            }
            if (x == RedBlackTree.leftOf(RedBlackTree.parentOf(x))) {
                x = RedBlackTree.parentOf(x);
                this.rotateRight(x);
            }
            RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackNode.NodeColor.BLACK);
            RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(x)), RedBlackNode.NodeColor.RED);
            if (RedBlackTree.parentOf(RedBlackTree.parentOf(x)) == null) continue;
            this.rotateLeft(RedBlackTree.parentOf(RedBlackTree.parentOf(x)));
        }
        this.root.color = RedBlackNode.NodeColor.BLACK;
    }

    public void deleteEntry(RedBlackNode<K, V> p) {
        RedBlackNode replacement;
        --this.size;
        if (p.left != null && p.right != null) {
            RedBlackNode<K, V> node = p.getSuccessor();
            this.swapPosition(node, p);
        }
        RedBlackNode redBlackNode = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p.isLeftChild()) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color == RedBlackNode.NodeColor.BLACK) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color == RedBlackNode.NodeColor.BLACK) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p.isLeftChild()) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(RedBlackNode<K, V> x) {
        while (x != this.root && RedBlackTree.colorOf(x) == RedBlackNode.NodeColor.BLACK) {
            RedBlackNode<K, V> sib;
            if (x == RedBlackTree.leftOf(RedBlackTree.parentOf(x))) {
                sib = RedBlackTree.rightOf(RedBlackTree.parentOf(x));
                if (RedBlackTree.colorOf(sib) == RedBlackNode.NodeColor.RED) {
                    RedBlackTree.setColor(sib, RedBlackNode.NodeColor.BLACK);
                    RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackNode.NodeColor.RED);
                    this.rotateLeft(RedBlackTree.parentOf(x));
                    sib = RedBlackTree.rightOf(RedBlackTree.parentOf(x));
                }
                if (RedBlackTree.colorOf(RedBlackTree.leftOf(sib)) == RedBlackNode.NodeColor.BLACK && RedBlackTree.colorOf(RedBlackTree.rightOf(sib)) == RedBlackNode.NodeColor.BLACK) {
                    RedBlackTree.setColor(sib, RedBlackNode.NodeColor.RED);
                    x = RedBlackTree.parentOf(x);
                    continue;
                }
                if (RedBlackTree.colorOf(RedBlackTree.rightOf(sib)) == RedBlackNode.NodeColor.BLACK) {
                    RedBlackTree.setColor(RedBlackTree.leftOf(sib), RedBlackNode.NodeColor.BLACK);
                    RedBlackTree.setColor(sib, RedBlackNode.NodeColor.RED);
                    this.rotateRight(sib);
                    sib = RedBlackTree.rightOf(RedBlackTree.parentOf(x));
                }
                RedBlackTree.setColor(sib, RedBlackTree.colorOf(RedBlackTree.parentOf(x)));
                RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackNode.NodeColor.BLACK);
                RedBlackTree.setColor(RedBlackTree.rightOf(sib), RedBlackNode.NodeColor.BLACK);
                this.rotateLeft(RedBlackTree.parentOf(x));
                x = this.root;
                continue;
            }
            sib = RedBlackTree.leftOf(RedBlackTree.parentOf(x));
            if (RedBlackTree.colorOf(sib) == RedBlackNode.NodeColor.RED) {
                RedBlackTree.setColor(sib, RedBlackNode.NodeColor.BLACK);
                RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackNode.NodeColor.RED);
                this.rotateRight(RedBlackTree.parentOf(x));
                sib = RedBlackTree.leftOf(RedBlackTree.parentOf(x));
            }
            if (RedBlackTree.colorOf(RedBlackTree.rightOf(sib)) == RedBlackNode.NodeColor.BLACK && RedBlackTree.colorOf(RedBlackTree.leftOf(sib)) == RedBlackNode.NodeColor.BLACK) {
                RedBlackTree.setColor(sib, RedBlackNode.NodeColor.RED);
                x = RedBlackTree.parentOf(x);
                continue;
            }
            if (RedBlackTree.colorOf(RedBlackTree.leftOf(sib)) == RedBlackNode.NodeColor.BLACK) {
                RedBlackTree.setColor(RedBlackTree.rightOf(sib), RedBlackNode.NodeColor.BLACK);
                RedBlackTree.setColor(sib, RedBlackNode.NodeColor.RED);
                this.rotateLeft(sib);
                sib = RedBlackTree.leftOf(RedBlackTree.parentOf(x));
            }
            RedBlackTree.setColor(sib, RedBlackTree.colorOf(RedBlackTree.parentOf(x)));
            RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackNode.NodeColor.BLACK);
            RedBlackTree.setColor(RedBlackTree.leftOf(sib), RedBlackNode.NodeColor.BLACK);
            this.rotateRight(RedBlackTree.parentOf(x));
            x = this.root;
        }
        RedBlackTree.setColor(x, RedBlackNode.NodeColor.BLACK);
    }

    private void swapPosition(RedBlackNode<K, V> x, RedBlackNode<K, V> y) {
        boolean yWasLeftChild;
        RedBlackNode px = x.parent;
        RedBlackNode lx = x.left;
        RedBlackNode rx = x.right;
        RedBlackNode py = y.parent;
        RedBlackNode ly = y.left;
        RedBlackNode ry = y.right;
        boolean xWasLeftChild = px != null && x == px.left;
        boolean bl = yWasLeftChild = py != null && y == py.left;
        if (x == py) {
            x.parent = y;
            if (yWasLeftChild) {
                y.left = x;
                y.right = rx;
            } else {
                y.right = x;
                y.left = lx;
            }
        } else {
            x.parent = py;
            if (py != null) {
                if (yWasLeftChild) {
                    py.left = x;
                } else {
                    py.right = x;
                }
            }
            y.left = lx;
            y.right = rx;
        }
        if (y == px) {
            y.parent = x;
            if (xWasLeftChild) {
                x.left = y;
                x.right = ry;
            } else {
                x.right = y;
                x.left = ly;
            }
        } else {
            y.parent = px;
            if (px != null) {
                if (xWasLeftChild) {
                    px.left = y;
                } else {
                    px.right = y;
                }
            }
            x.left = ly;
            x.right = ry;
        }
        if (x.left != null) {
            x.left.parent = x;
        }
        if (x.right != null) {
            x.right.parent = x;
        }
        if (y.left != null) {
            y.left.parent = y;
        }
        if (y.right != null) {
            y.right.parent = y;
        }
        RedBlackNode.NodeColor c = x.color;
        x.color = y.color;
        y.color = c;
        if (this.root == x) {
            this.root = y;
        } else if (this.root == y) {
            this.root = x;
        }
    }
}

