/*
 * Decompiled with CFR 0.152.
 */
package generic.lsh.vector;

import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class IDFLookup {
    private int size;
    private int mask = 0;
    private IDFEntry[] hashtable = null;

    private void initializeTable() {
        this.mask = 1;
        while (this.mask < this.size) {
            this.mask <<= 1;
        }
        this.mask <<= 1;
        this.hashtable = new IDFEntry[this.mask];
        for (int i = 0; i < this.mask; ++i) {
            this.hashtable[i] = new IDFEntry(this);
            this.hashtable[i].count = -1;
        }
        --this.mask;
    }

    public boolean empty() {
        return this.hashtable == null;
    }

    public int getCount(int hash) {
        if (this.mask == 0) {
            return 0;
        }
        int val = hash & this.mask;
        IDFEntry entry = this.hashtable[val];
        while (entry.count != -1) {
            if (entry.hash == hash) {
                return entry.count;
            }
            val = val + 1 & this.mask;
            entry = this.hashtable[val];
        }
        return 0;
    }

    public int getCapacity() {
        return this.mask;
    }

    public int getRawHash(int pos) {
        return this.hashtable[pos].hash;
    }

    public int getRawCount(int pos) {
        return this.hashtable[pos].count;
    }

    private void insertHash(int hash, int count) {
        int val = hash & this.mask;
        while (true) {
            IDFEntry entry = this.hashtable[val];
            if (entry.count == -1) break;
            val = val + 1 & this.mask;
        }
        entry.hash = hash;
        entry.count = count;
    }

    public void saveXml(Writer fwrite) throws IOException {
        if (this.empty()) {
            fwrite.append("<idflookup/>\n");
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<idflookup");
        SpecXmlUtils.encodeSignedIntegerAttribute(buf, "size", this.size);
        buf.append(">\n");
        int sz = this.mask + 1;
        for (int i = 0; i < sz; ++i) {
            IDFEntry entry = this.hashtable[i];
            if (entry.count == -1) continue;
            buf.append("<hash");
            SpecXmlUtils.encodeSignedIntegerAttribute(buf, "count", entry.count);
            buf.append('>');
            buf.append(SpecXmlUtils.encodeUnsignedInteger(entry.hash));
            buf.append("</hash>\n");
        }
        buf.append("</idflookup>\n");
        fwrite.append(buf.toString());
    }

    public void restoreXml(XmlPullParser parser) {
        XmlElement el = parser.start(new String[]{"idflookup"});
        if (!el.hasAttribute("size")) {
            return;
        }
        this.size = SpecXmlUtils.decodeInt(el.getAttribute("size"));
        this.initializeTable();
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[]{"hash"});
            int count = SpecXmlUtils.decodeInt(subel.getAttribute("count"));
            int hash = SpecXmlUtils.decodeInt(parser.end().getText());
            this.insertHash(hash, count);
        }
        parser.end(el);
    }

    public int[] toArray() {
        int count = 0;
        for (int i = 0; i < this.hashtable.length; ++i) {
            if (this.hashtable[i].count == -1) continue;
            ++count;
        }
        int[] res = new int[count * 2];
        int pos = 0;
        for (int i = 0; i < this.hashtable.length; ++i) {
            if (this.hashtable[i].count == -1) continue;
            res[pos] = this.hashtable[i].hash;
            res[++pos] = this.hashtable[i].count;
            ++pos;
        }
        return res;
    }

    public void set(int[] hashCountPair) {
        this.size = hashCountPair.length / 2;
        this.initializeTable();
        for (int i = 0; i < hashCountPair.length; i += 2) {
            this.insertHash(hashCountPair[i], hashCountPair[i + 1]);
        }
    }

    public class IDFEntry {
        public int hash;
        public int count;

        public IDFEntry(IDFLookup this$0) {
        }
    }
}

