/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFTag;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeClass;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.program.model.data.LEB128;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class DWARFAbbreviation {
    private static final int EOL = 0;
    private final int abbreviationCode;
    private final DWARFTag tag;
    private final int tagId;
    private final boolean hasChildren;
    private final DWARFAttribute.AttrDef[] attributes;

    public static DWARFAbbreviation read(BinaryReader reader, DWARFProgram prog, TaskMonitor monitor) throws IOException, CancelledException {
        DWARFAttribute.AttrDef attrSpec;
        int ac = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        if (ac == 0) {
            return null;
        }
        int tag = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        byte hasChildren = reader.readNextByte();
        ArrayList<DWARFAttribute.AttrDef> tmpAttrSpecs = new ArrayList<DWARFAttribute.AttrDef>();
        while ((attrSpec = DWARFAttribute.AttrDef.read(reader)) != null) {
            monitor.checkCancelled();
            attrSpec = prog.internAttributeSpec(attrSpec);
            tmpAttrSpecs.add(attrSpec);
            DWARFAbbreviation.warnIfMismatchedForms(attrSpec);
        }
        DWARFAttribute.AttrDef[] attrSpecArray = tmpAttrSpecs.toArray(new DWARFAttribute.AttrDef[tmpAttrSpecs.size()]);
        DWARFAbbreviation result = new DWARFAbbreviation(ac, tag, hasChildren == 1, attrSpecArray);
        return result;
    }

    private static void warnIfMismatchedForms(DWARFAttribute.AttrDef attrSpec) {
        DWARFForm form = attrSpec.getAttributeForm();
        DWARFAttribute attribute = (DWARFAttribute)((Object)attrSpec.getAttributeId());
        if (attribute != null && !form.getFormClasses().isEmpty() && !attribute.getAttributeClass().isEmpty()) {
            EnumSet<DWARFAttributeClass> tmp = EnumSet.copyOf(attrSpec.getAttributeForm().getFormClasses());
            tmp.retainAll(((DWARFAttribute)((Object)attrSpec.getAttributeId())).getAttributeClass());
            if (tmp.isEmpty()) {
                Msg.warn(DWARFAbbreviation.class, (Object)"Mismatched DWARF Attribute and Form: %s".formatted(attrSpec));
            }
        }
    }

    public static Map<Integer, DWARFAbbreviation> readAbbreviations(BinaryReader reader, DWARFProgram prog, TaskMonitor monitor) throws IOException, CancelledException {
        HashMap<Integer, DWARFAbbreviation> result = new HashMap<Integer, DWARFAbbreviation>();
        DWARFAbbreviation abbrev = null;
        while ((abbrev = DWARFAbbreviation.read(reader, prog, monitor)) != null) {
            monitor.checkCancelled();
            result.put(abbrev.getAbbreviationCode(), abbrev);
        }
        return result;
    }

    public DWARFAbbreviation(int abbreviationCode, int tagId, boolean hasChildren, DWARFAttribute.AttrDef[] attributes) {
        this.abbreviationCode = abbreviationCode;
        this.tagId = tagId;
        this.tag = DWARFTag.of(tagId);
        this.hasChildren = hasChildren;
        this.attributes = attributes;
    }

    public String toString() {
        return "%x:%s".formatted(this.abbreviationCode, this.getTagName());
    }

    public int getAbbreviationCode() {
        return this.abbreviationCode;
    }

    public DWARFTag getTag() {
        return this.tag;
    }

    public String getTagName() {
        return this.tag.name(this.tagId);
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public DWARFAttribute.AttrDef[] getAttributes() {
        return this.attributes;
    }

    public int getAttributeCount() {
        return this.attributes.length;
    }

    public DWARFAttribute.AttrDef getAttributeAt(int index) {
        return this.attributes[index];
    }

    public DWARFAttribute.AttrDef findAttribute(DWARFAttribute attributeId) {
        for (DWARFAttribute.AttrDef spec : this.attributes) {
            if (spec.getAttributeId() != attributeId) continue;
            return spec;
        }
        return null;
    }
}

