/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import generic.util.WindowUtilities;
import ghidra.app.plugin.core.console.CodeCompletion;
import ghidra.app.plugin.core.interpreter.CodeCompletionListCellRenderer;
import ghidra.app.plugin.core.interpreter.CodeCompletionListModel;
import ghidra.app.plugin.core.interpreter.CodeCompletionListSelectionModel;
import ghidra.app.plugin.core.interpreter.InterpreterPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class CodeCompletionWindow
extends JDialog {
    private static final String FONT_ID = "font.plugin.terminal.completion.list";
    protected final InterpreterPanel console;
    protected final JTextPane outputTextField;
    protected List<CodeCompletion> completionData;
    protected JList<CodeCompletion> jlist;

    public CodeCompletionWindow(Window parent, InterpreterPanel cp, JTextPane textField) {
        super(parent);
        this.console = cp;
        this.outputTextField = textField;
        this.jlist = new JList();
        this.completionData = null;
        this.setUndecorated(true);
        this.setFocusableWindowState(false);
        this.jlist.setBackground((Color)GThemeDefaults.Colors.Tooltips.BACKGROUND);
        this.jlist.setCellRenderer((ListCellRenderer<CodeCompletion>)((Object)new CodeCompletionListCellRenderer()));
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CodeCompletionWindow.this.outputTextField.requestFocusInWindow();
                if (e.getClickCount() == 2) {
                    CodeCompletionWindow.this.console.insertCompletion(CodeCompletionWindow.this.getCompletion());
                }
            }
        };
        this.jlist.addMouseListener(mouseListener);
        this.getContentPane().add(new JScrollPane(this.jlist));
        this.updateCompletionList(this.completionData);
        this.jlist.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CodeCompletionWindow.this.processKeyEvent(e);
            }
        });
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
    }

    public void updateCompletionList(List<CodeCompletion> list) {
        this.completionData = list;
        this.jlist.setModel(new CodeCompletionListModel(list));
        this.jlist.setSelectionModel(new CodeCompletionListSelectionModel(list));
        this.jlist.clearSelection();
        this.pack();
        this.updateWindowLocation();
        this.invalidate();
    }

    private void updateWindowLocation() {
        Point caretLocation = this.outputTextField.getCaret().getMagicCaretPosition();
        if (caretLocation == null) {
            return;
        }
        this.updateLocation(caretLocation);
    }

    public void updateLocation(Point caretLocation) {
        if (!this.outputTextField.isShowing()) {
            return;
        }
        Point converted = new Point(caretLocation);
        SwingUtilities.convertPointToScreen(converted, this.outputTextField);
        Rectangle screenBounds = WindowUtilities.getScreenBounds((Component)this.outputTextField);
        if (!screenBounds.contains(converted)) {
            return;
        }
        Point newLocation = this.ensureLocationOnScreen(converted);
        this.setLocation(newLocation);
    }

    private Point ensureLocationOnScreen(Point location) {
        int offset;
        Point newPoint;
        Rectangle screenBounds = WindowUtilities.getScreenBounds((Component)this.outputTextField);
        int screenWidth = screenBounds.width;
        int screenHeight = screenBounds.height;
        int myWidth = this.getWidth();
        int myHeight = this.getHeight();
        int textHeight = this.outputTextField.getHeight();
        if (this.getWidth() > screenWidth) {
            this.setSize(screenWidth, this.getHeight());
        }
        if (this.isOnScreen(screenBounds, newPoint = new Point(location.x + (offset = textHeight), location.y + offset))) {
            return newPoint;
        }
        Point testPoint = null;
        if (newPoint.x + myWidth > screenWidth) {
            testPoint = newPoint.y + myHeight > screenHeight ? new Point(screenWidth - myWidth, newPoint.y - myHeight - offset) : new Point(screenWidth - myWidth, newPoint.y);
        } else if (newPoint.y + myHeight > screenHeight) {
            testPoint = new Point(newPoint.x, screenHeight - myHeight - offset);
        }
        newPoint = this.validateLocation(screenBounds, testPoint, newPoint);
        return newPoint;
    }

    private boolean isOnScreen(Rectangle screenBounds, Point testPoint) {
        Rectangle testBounds = new Rectangle(testPoint.x, testPoint.y, this.getWidth(), this.getHeight());
        return screenBounds.contains(testBounds);
    }

    private Point validateLocation(Rectangle screenBounds, Point testPoint, Point defaultPoint) {
        if (testPoint == null) {
            return defaultPoint;
        }
        Rectangle testBounds = new Rectangle(testPoint.x, testPoint.y, this.getWidth(), this.getHeight());
        if (screenBounds.contains(testBounds)) {
            return testPoint;
        }
        return defaultPoint;
    }

    @Override
    public void setFont(Font font) {
        Gui.registerFont(this.jlist, (String)FONT_ID);
    }

    public void selectPrevious() {
        for (int i = this.jlist.getSelectedIndex() - 1; i >= 0; --i) {
            CodeCompletion completion = this.completionData.get(i);
            if (!CodeCompletion.isValid(completion)) continue;
            this.jlist.setSelectedIndex(i);
            this.jlist.ensureIndexIsVisible(i);
            break;
        }
    }

    public void selectNext() {
        if (null == this.completionData) {
            return;
        }
        for (int i = this.jlist.getSelectedIndex() + 1; i < this.completionData.size(); ++i) {
            CodeCompletion completion = this.completionData.get(i);
            if (!CodeCompletion.isValid(completion)) continue;
            this.jlist.setSelectedIndex(i);
            this.jlist.ensureIndexIsVisible(i);
            break;
        }
    }

    public CodeCompletion getCompletion() {
        int i = this.jlist.getSelectedIndex();
        if (-1 == i) {
            return null;
        }
        return this.completionData.get(i);
    }
}

