/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.widgets.label.GLabel;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.equate.EquateReferenceTableModel;
import ghidra.app.plugin.core.equate.EquateTableModel;
import ghidra.app.plugin.core.equate.EquateTablePlugin;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.util.HelpLocation;
import ghidra.util.UniversalID;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.SelectionNavigationAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import resources.Icons;

public class EquateTableProvider
extends ComponentProviderAdapter {
    private EquateTablePlugin plugin;
    private GhidraTable equatesTable;
    private EquateTableModel equatesModel;
    private GhidraTable referencesTable;
    private EquateReferenceTableModel referencesModel;
    private DockingAction deleteAction;
    private JPanel mainPanel;
    private GhidraTableFilterPanel<Equate> equatesFilterPanel;

    EquateTableProvider(EquateTablePlugin plugin) {
        super(plugin.getTool(), "Equates Table", plugin.getName(), ProgramActionContext.class);
        this.setHelpLocation(new HelpLocation("EquatePlugin", "Equate Table"));
        this.plugin = plugin;
        this.mainPanel = this.createWorkPanel();
        this.addToTool();
        this.createActions();
    }

    public void closeComponent() {
        super.closeComponent();
        this.plugin.componentClosed();
    }

    public void componentShown() {
        this.plugin.componentShown();
        this.updateEquates();
    }

    public ActionContext getActionContext(MouseEvent event) {
        Program program = this.plugin.getProgram();
        if (program == null) {
            return null;
        }
        if (event != null && event.getSource() == this.referencesTable) {
            return new ProgramActionContext((ComponentProvider)this, program, (Component)((Object)this.referencesTable));
        }
        return new ProgramActionContext((ComponentProvider)this, program, (Component)((Object)this.equatesTable));
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    void programOpened(Program program) {
        this.equatesModel.update();
        this.referencesModel.setEquate(null);
    }

    void programClosed() {
        this.equatesModel.update();
        this.referencesModel.setEquate(null);
    }

    void updateEquates() {
        List selectedItems = this.equatesFilterPanel.getSelectedItems();
        this.equatesModel.update();
        this.equatesFilterPanel.setSelectedItems(selectedItems);
        this.handleEquateTableSelection();
    }

    void showEquates() {
        this.tool.showComponentProvider((ComponentProvider)this, true);
    }

    void dispose() {
        this.removeFromTool();
        this.equatesFilterPanel.dispose();
        this.referencesTable.dispose();
    }

    GhidraTable getReferencesTable() {
        return this.referencesTable;
    }

    GhidraTable getEquatesTable() {
        return this.equatesTable;
    }

    private JPanel createWorkPanel() {
        this.equatesModel = new EquateTableModel(this.plugin);
        this.equatesTable = new GhidraTable((TableModel)((Object)this.equatesModel));
        this.equatesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EquateTableProvider.this.handleEquateTableSelection();
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 33 || e.getKeyCode() == 34) {
                    EquateTableProvider.this.handleEquateTableSelection();
                }
            }
        });
        this.equatesTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.handleEquateTableSelection();
        });
        this.equatesTable.setAutoResizeMode(4);
        this.equatesTable.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.equatesTable.setRowSelectionAllowed(true);
        this.equatesTable.setSelectionMode(2);
        this.equatesFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.equatesTable), this.equatesModel);
        JScrollPane equatesTablePane = new JScrollPane((Component)((Object)this.equatesTable));
        JPanel equatesPanel = new JPanel(new BorderLayout());
        equatesPanel.add((Component)new GLabel("Equates", 0), "North");
        equatesPanel.add((Component)equatesTablePane, "Center");
        equatesPanel.add((Component)((Object)this.equatesFilterPanel), "South");
        this.referencesModel = new EquateReferenceTableModel(this.plugin);
        String namePrefix = "Equates";
        this.equatesTable.setAccessibleNamePrefix(namePrefix);
        this.equatesFilterPanel.setAccessibleNamePrefix(namePrefix);
        this.referencesTable = new GhidraTable((TableModel)((Object)this.referencesModel));
        this.referencesTable.installNavigation((ServiceProvider)this.tool);
        this.referencesTable.setAutoResizeMode(4);
        this.referencesTable.setPreferredScrollableViewportSize(new Dimension(250, 150));
        this.referencesTable.setRowSelectionAllowed(true);
        this.referencesTable.setSelectionMode(0);
        this.referencesTable.setAccessibleNamePrefix("Equates References");
        JScrollPane referencesTablePane = new JScrollPane((Component)((Object)this.referencesTable));
        JTableHeader referencesHeader = this.referencesTable.getTableHeader();
        referencesHeader.setUpdateTableInRealTime(true);
        JPanel referencesPanel = new JPanel(new BorderLayout());
        referencesPanel.add((Component)new GLabel("References", 0), "North");
        referencesPanel.add((Component)referencesTablePane, "Center");
        JPanel workPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, equatesPanel, referencesPanel);
        splitPane.setResizeWeight(0.5);
        workPanel.add((Component)splitPane, "Center");
        return workPanel;
    }

    private void handleEquateTableSelection() {
        int[] rows = this.equatesTable.getSelectedRows();
        if (rows.length > 1) {
            this.referencesTable.clearSelection();
            this.referencesModel.setEquate(null);
            return;
        }
        Equate equate = (Equate)this.equatesFilterPanel.getSelectedItem();
        this.referencesTable.clearSelection();
        this.referencesModel.setEquate(equate);
    }

    private void createActions() {
        String group = "Popup Group";
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Show Enum", this.plugin.getName()).popupMenuGroup(group)).popupMenuPath(new String[]{"Show Enum"})).popupWhen(c -> true)).enabledWhen(c -> this.getEnum(this.getSelectedEquate()) != null)).onAction(c -> {
            DataTypeManagerService dtms = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
            if (dtms != null) {
                dtms.setDataTypeSelected((DataType)this.getEnum(this.getSelectedEquate()));
            }
        })).helpLocation(new HelpLocation("EquatePlugin", "Show_Enum"))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Edit Enum", this.plugin.getName()).popupMenuGroup(group)).popupMenuPath(new String[]{"Edit Enum"})).popupWhen(c -> true)).enabledWhen(c -> this.getEnum(this.getSelectedEquate()) != null)).onAction(c -> this.edit(this.getEnum(this.getSelectedEquate())))).helpLocation(new HelpLocation("EquatePlugin", "Edit_Enum"))).buildAndInstallLocal((ComponentProvider)this);
        Icon deleteImage = Icons.DELETE_ICON;
        this.deleteAction = new DockingAction("Delete Equate", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EquateTableProvider.this.delete();
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (context.getContextObject() == EquateTableProvider.this.equatesTable) {
                    return super.isEnabledForContext(context);
                }
                return false;
            }
        };
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, deleteImage));
        this.deleteAction.setToolBarData(new ToolBarData(deleteImage));
        this.deleteAction.setDescription("Delete an Equate");
        this.deleteAction.setHelpLocation(new HelpLocation("EquatePlugin", "Delete Equate"));
        SelectionNavigationAction selectionNavigationAction = new SelectionNavigationAction(this.plugin, this.referencesTable);
        selectionNavigationAction.setHelpLocation(new HelpLocation("Search", "Selection_Navigation"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)selectionNavigationAction);
    }

    private Equate getSelectedEquate() {
        if (this.equatesTable.getSelectedRowCount() != 1) {
            return null;
        }
        return (Equate)this.equatesFilterPanel.getSelectedItem();
    }

    private Enum getEnum(Equate equate) {
        if (equate == null) {
            return null;
        }
        if (!equate.isEnumBased()) {
            return null;
        }
        DataTypeManagerService dtms = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (dtms == null) {
            return null;
        }
        ProgramBasedDataTypeManager dtm = this.plugin.getProgram().getDataTypeManager();
        UniversalID id = equate.getEnumUUID();
        Enum enoom = (Enum)dtm.findDataTypeForID(id);
        return enoom;
    }

    private void edit(Enum enoom) {
        DataTypeManagerService dtms = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (dtms != null) {
            dtms.edit((DataType)enoom);
        }
    }

    private void delete() {
        TableCellEditor cellEditor = this.equatesTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        List equates = this.equatesFilterPanel.getSelectedItems();
        this.plugin.deleteEquates(equates);
    }

    EquateTableModel getEquatesModel() {
        return this.equatesModel;
    }

    Program getProgram() {
        return this.plugin.getProgram();
    }
}

