/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.List;

public class UpdateFunctionCommand
implements Command<Program> {
    private final Function function;
    private final Function.FunctionUpdateType updateType;
    private final String callingConvention;
    private final Variable returnVar;
    private final List<? extends Variable> params;
    private final SourceType source;
    private final boolean force;
    private String statusMessage;

    public UpdateFunctionCommand(Function function, Function.FunctionUpdateType updateType, String callingConvention, Variable returnVar, List<? extends Variable> params, SourceType source, boolean force) {
        this.function = function;
        this.updateType = updateType;
        this.callingConvention = callingConvention;
        this.returnVar = returnVar;
        this.params = params;
        this.source = source;
        this.force = force;
    }

    public boolean applyTo(Program obj) {
        try {
            this.function.updateFunction(this.callingConvention, this.returnVar, this.params, this.updateType, this.force, this.source);
            return true;
        }
        catch (DuplicateNameException | InvalidInputException e) {
            this.statusMessage = e.getMessage();
            return false;
        }
    }

    public String getStatusMsg() {
        return this.statusMessage;
    }

    public String getName() {
        return "Update Function";
    }
}

