/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.disassemble;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class SetFlowOverrideCmd
extends BackgroundCommand<Program> {
    Address instAddr;
    AddressSetView set;
    FlowOverride flowOverride;

    public SetFlowOverrideCmd(Address instAddr, FlowOverride flowOverride) {
        this(null, instAddr, flowOverride);
    }

    public SetFlowOverrideCmd(AddressSetView set, FlowOverride flowOverride) {
        this(set, null, flowOverride);
    }

    private SetFlowOverrideCmd(AddressSetView set, Address instAddr, FlowOverride flowOverride) {
        super("Set Flow Override", true, true, true);
        this.instAddr = instAddr;
        this.set = set;
        this.flowOverride = flowOverride;
    }

    public boolean applyTo(Program program, TaskMonitor monitor) {
        if (this.set != null) {
            int cnt = 0;
            monitor.initialize((long)this.set.getNumAddressRanges());
            for (Instruction instr : program.getListing().getInstructions(this.set, true)) {
                if (monitor.isCancelled()) break;
                instr.setFlowOverride(this.flowOverride);
                monitor.setProgress((long)(++cnt));
            }
            return true;
        }
        Instruction instr = program.getListing().getInstructionAt(this.instAddr);
        if (instr == null) {
            return false;
        }
        if (instr.getFlowOverride() == this.flowOverride) {
            return true;
        }
        instr.setFlowOverride(this.flowOverride);
        return true;
    }
}

