/*
 * Decompiled with CFR 0.152.
 */
package ghidra.macosx.plugins;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.util.dialog.AskAddrDialog;
import ghidra.app.util.opinion.DyldCacheExtractLoader;
import ghidra.file.formats.ios.dyldcache.DyldCacheFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="DYLD Cache Builder", description="This plugin provides actions for adding DYLD Cache components to the program")
public class DyldCacheBuilderPlugin
extends Plugin {
    public DyldCacheBuilderPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        String addActionName = "Add To Program";
        new ActionBuilder("Add To Program", this.getName()).withContext(ProgramLocationActionContext.class).enabledWhen(context -> context.getProgram().getExecutableFormat().equals("Extracted DYLD Component")).onAction(context -> TaskLauncher.launchModal((String)"Add To Program", monitor -> this.addMissingDyldCacheComponent(context.getLocation(), monitor))).popupMenuPath(new String[]{"References", "Add To Program"}).popupMenuGroup("Add").helpLocation(new HelpLocation("ImporterPlugin", "Add_To_Program")).buildAndInstall((Tool)this.tool);
    }

    private void addMissingDyldCacheComponent(ProgramLocation location, TaskMonitor monitor) {
        Program program = location.getProgram();
        Address address = location.getRefAddress();
        if (address == null) {
            AskAddrDialog dialog = new AskAddrDialog(this.name, "Enter address", program, null);
            if (dialog.isCanceled()) {
                return;
            }
            address = dialog.getValueAsAddress();
        }
        if (address.getAddressSpace().isExternalSpace()) {
            Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"External locations are not currently supported");
            return;
        }
        if (program.getMemory().contains(address)) {
            Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"Address %s already exists in memory".formatted(address));
            return;
        }
        try (FileSystemRef fsRef2 = DyldCacheExtractLoader.openDyldCache(program, monitor);){
            DyldCacheFileSystem fs = (DyldCacheFileSystem)fsRef2.getFilesystem();
            long offset = address.getOffset();
            String fsPath = fs.findAddress(offset);
            if (fsPath != null) {
                ImporterUtilities.showAddToProgramDialog((FSRL)fs.getFSRL().appendPath(fsPath), (Program)program, (PluginTool)this.tool, (TaskMonitor)monitor);
            } else {
                Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"Address %s not found in %s".formatted(address, fs.toString()));
            }
        }
        catch (CancelledException fsRef2) {
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)this.name, (Object)e.getMessage(), (Throwable)e);
        }
    }
}

